@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property amazonMskCluster Details of an Amazon MSK cluster.
 * @property vpcConfig Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
 */
public data class ReplicatorKafkaClusterArgs(
    public val amazonMskCluster: Output<ReplicatorKafkaClusterAmazonMskClusterArgs>,
    public val vpcConfig: Output<ReplicatorKafkaClusterVpcConfigArgs>,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterArgs =
        com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterArgs.builder()
            .amazonMskCluster(amazonMskCluster.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vpcConfig(vpcConfig.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ReplicatorKafkaClusterArgs].
 */
@PulumiTagMarker
public class ReplicatorKafkaClusterArgsBuilder internal constructor() {
    private var amazonMskCluster: Output<ReplicatorKafkaClusterAmazonMskClusterArgs>? = null

    private var vpcConfig: Output<ReplicatorKafkaClusterVpcConfigArgs>? = null

    /**
     * @param value Details of an Amazon MSK cluster.
     */
    @JvmName("xfkhgirsfikdxkhy")
    public suspend fun amazonMskCluster(`value`: Output<ReplicatorKafkaClusterAmazonMskClusterArgs>) {
        this.amazonMskCluster = value
    }

    /**
     * @param value Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
     */
    @JvmName("lhxehqoiyemqdixn")
    public suspend fun vpcConfig(`value`: Output<ReplicatorKafkaClusterVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value Details of an Amazon MSK cluster.
     */
    @JvmName("wrrekykkyeepjclq")
    public suspend fun amazonMskCluster(`value`: ReplicatorKafkaClusterAmazonMskClusterArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.amazonMskCluster = mapped
    }

    /**
     * @param argument Details of an Amazon MSK cluster.
     */
    @JvmName("putcllagxpljbvnj")
    public suspend fun amazonMskCluster(argument: suspend ReplicatorKafkaClusterAmazonMskClusterArgsBuilder.() -> Unit) {
        val toBeMapped = ReplicatorKafkaClusterAmazonMskClusterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.amazonMskCluster = mapped
    }

    /**
     * @param value Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
     */
    @JvmName("ygdqtlikwjhsghof")
    public suspend fun vpcConfig(`value`: ReplicatorKafkaClusterVpcConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
     */
    @JvmName("jkbvgdkfrpijttjq")
    public suspend fun vpcConfig(argument: suspend ReplicatorKafkaClusterVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ReplicatorKafkaClusterVpcConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): ReplicatorKafkaClusterArgs = ReplicatorKafkaClusterArgs(
        amazonMskCluster = amazonMskCluster ?: throw PulumiNullFieldException("amazonMskCluster"),
        vpcConfig = vpcConfig ?: throw PulumiNullFieldException("vpcConfig"),
    )
}
