@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterVpcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupsIds The AWS security groups to associate with the ENIs used by the replicator. If a security group is not specified, the default security group associated with the VPC is used.
 * @property subnetIds The list of subnets to connect to in the virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets to allow communication between your Kafka Cluster and the replicator.
 */
public data class ReplicatorKafkaClusterVpcConfigArgs(
    public val securityGroupsIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterVpcConfigArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterVpcConfigArgs =
        com.pulumi.aws.msk.inputs.ReplicatorKafkaClusterVpcConfigArgs.builder()
            .securityGroupsIds(securityGroupsIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ReplicatorKafkaClusterVpcConfigArgs].
 */
@PulumiTagMarker
public class ReplicatorKafkaClusterVpcConfigArgsBuilder internal constructor() {
    private var securityGroupsIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    /**
     * @param value The AWS security groups to associate with the ENIs used by the replicator. If a security group is not specified, the default security group associated with the VPC is used.
     */
    @JvmName("oviinbkttaytqaav")
    public suspend fun securityGroupsIds(`value`: Output<List<String>>) {
        this.securityGroupsIds = value
    }

    @JvmName("ytixugngjvojvydt")
    public suspend fun securityGroupsIds(vararg values: Output<String>) {
        this.securityGroupsIds = Output.all(values.asList())
    }

    /**
     * @param values The AWS security groups to associate with the ENIs used by the replicator. If a security group is not specified, the default security group associated with the VPC is used.
     */
    @JvmName("skmpomxmicjoqjgs")
    public suspend fun securityGroupsIds(values: List<Output<String>>) {
        this.securityGroupsIds = Output.all(values)
    }

    /**
     * @param value The list of subnets to connect to in the virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets to allow communication between your Kafka Cluster and the replicator.
     */
    @JvmName("gpgrqhwjkttsoale")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("khrylxnsddswpiih")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values The list of subnets to connect to in the virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets to allow communication between your Kafka Cluster and the replicator.
     */
    @JvmName("lxcojafortgyxnkq")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value The AWS security groups to associate with the ENIs used by the replicator. If a security group is not specified, the default security group associated with the VPC is used.
     */
    @JvmName("mcgkqxjqthhgsoox")
    public suspend fun securityGroupsIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupsIds = mapped
    }

    /**
     * @param values The AWS security groups to associate with the ENIs used by the replicator. If a security group is not specified, the default security group associated with the VPC is used.
     */
    @JvmName("pelwybdcarvpkbvb")
    public suspend fun securityGroupsIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupsIds = mapped
    }

    /**
     * @param value The list of subnets to connect to in the virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets to allow communication between your Kafka Cluster and the replicator.
     */
    @JvmName("avjmowgejtkokibp")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values The list of subnets to connect to in the virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets to allow communication between your Kafka Cluster and the replicator.
     */
    @JvmName("yrxglewsxxovjupl")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    internal fun build(): ReplicatorKafkaClusterVpcConfigArgs = ReplicatorKafkaClusterVpcConfigArgs(
        securityGroupsIds = securityGroupsIds,
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
    )
}
