@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property consumerGroupReplications Configuration relating to consumer group replication.
 * @property sourceKafkaClusterAlias
 * @property sourceKafkaClusterArn The ARN of the source Kafka cluster.
 * @property targetCompressionType The type of compression to use writing records to target Kafka cluster.
 * @property targetKafkaClusterAlias
 * @property targetKafkaClusterArn The ARN of the target Kafka cluster.
 * @property topicReplications Configuration relating to topic replication.
 */
public data class ReplicatorReplicationInfoListArgs(
    public val consumerGroupReplications: Output<List<ReplicatorReplicationInfoListConsumerGroupReplicationArgs>>,
    public val sourceKafkaClusterAlias: Output<String>? = null,
    public val sourceKafkaClusterArn: Output<String>,
    public val targetCompressionType: Output<String>,
    public val targetKafkaClusterAlias: Output<String>? = null,
    public val targetKafkaClusterArn: Output<String>,
    public val topicReplications: Output<List<ReplicatorReplicationInfoListTopicReplicationArgs>>,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListArgs =
        com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListArgs.builder()
            .consumerGroupReplications(
                consumerGroupReplications.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sourceKafkaClusterAlias(sourceKafkaClusterAlias?.applyValue({ args0 -> args0 }))
            .sourceKafkaClusterArn(sourceKafkaClusterArn.applyValue({ args0 -> args0 }))
            .targetCompressionType(targetCompressionType.applyValue({ args0 -> args0 }))
            .targetKafkaClusterAlias(targetKafkaClusterAlias?.applyValue({ args0 -> args0 }))
            .targetKafkaClusterArn(targetKafkaClusterArn.applyValue({ args0 -> args0 }))
            .topicReplications(
                topicReplications.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ReplicatorReplicationInfoListArgs].
 */
@PulumiTagMarker
public class ReplicatorReplicationInfoListArgsBuilder internal constructor() {
    private var consumerGroupReplications:
        Output<List<ReplicatorReplicationInfoListConsumerGroupReplicationArgs>>? = null

    private var sourceKafkaClusterAlias: Output<String>? = null

    private var sourceKafkaClusterArn: Output<String>? = null

    private var targetCompressionType: Output<String>? = null

    private var targetKafkaClusterAlias: Output<String>? = null

    private var targetKafkaClusterArn: Output<String>? = null

    private var topicReplications: Output<List<ReplicatorReplicationInfoListTopicReplicationArgs>>? =
        null

    /**
     * @param value Configuration relating to consumer group replication.
     */
    @JvmName("egxpilnnjkpynjhv")
    public suspend fun consumerGroupReplications(`value`: Output<List<ReplicatorReplicationInfoListConsumerGroupReplicationArgs>>) {
        this.consumerGroupReplications = value
    }

    @JvmName("elmqrusavqcqcyrw")
    public suspend fun consumerGroupReplications(vararg values: Output<ReplicatorReplicationInfoListConsumerGroupReplicationArgs>) {
        this.consumerGroupReplications = Output.all(values.asList())
    }

    /**
     * @param values Configuration relating to consumer group replication.
     */
    @JvmName("lrimjxnlkjjwnrcw")
    public suspend fun consumerGroupReplications(values: List<Output<ReplicatorReplicationInfoListConsumerGroupReplicationArgs>>) {
        this.consumerGroupReplications = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("mwenxvfiuqyfiofr")
    public suspend fun sourceKafkaClusterAlias(`value`: Output<String>) {
        this.sourceKafkaClusterAlias = value
    }

    /**
     * @param value The ARN of the source Kafka cluster.
     */
    @JvmName("cqbeakiqdqevfctv")
    public suspend fun sourceKafkaClusterArn(`value`: Output<String>) {
        this.sourceKafkaClusterArn = value
    }

    /**
     * @param value The type of compression to use writing records to target Kafka cluster.
     */
    @JvmName("dedgfbabionafypj")
    public suspend fun targetCompressionType(`value`: Output<String>) {
        this.targetCompressionType = value
    }

    /**
     * @param value
     */
    @JvmName("uncldmxlcnhygcqg")
    public suspend fun targetKafkaClusterAlias(`value`: Output<String>) {
        this.targetKafkaClusterAlias = value
    }

    /**
     * @param value The ARN of the target Kafka cluster.
     */
    @JvmName("vktqlqathvdnscmq")
    public suspend fun targetKafkaClusterArn(`value`: Output<String>) {
        this.targetKafkaClusterArn = value
    }

    /**
     * @param value Configuration relating to topic replication.
     */
    @JvmName("negegrfnownbedat")
    public suspend fun topicReplications(`value`: Output<List<ReplicatorReplicationInfoListTopicReplicationArgs>>) {
        this.topicReplications = value
    }

    @JvmName("ephkqqdpvogrrrjm")
    public suspend fun topicReplications(vararg values: Output<ReplicatorReplicationInfoListTopicReplicationArgs>) {
        this.topicReplications = Output.all(values.asList())
    }

    /**
     * @param values Configuration relating to topic replication.
     */
    @JvmName("lkagxisamewiaogn")
    public suspend fun topicReplications(values: List<Output<ReplicatorReplicationInfoListTopicReplicationArgs>>) {
        this.topicReplications = Output.all(values)
    }

    /**
     * @param value Configuration relating to consumer group replication.
     */
    @JvmName("qjchbbgvueqxrljw")
    public suspend fun consumerGroupReplications(`value`: List<ReplicatorReplicationInfoListConsumerGroupReplicationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.consumerGroupReplications = mapped
    }

    /**
     * @param argument Configuration relating to consumer group replication.
     */
    @JvmName("npixstwujyuablqm")
    public suspend fun consumerGroupReplications(argument: List<suspend ReplicatorReplicationInfoListConsumerGroupReplicationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReplicatorReplicationInfoListConsumerGroupReplicationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.consumerGroupReplications = mapped
    }

    /**
     * @param argument Configuration relating to consumer group replication.
     */
    @JvmName("lndkacnlkcxakhmv")
    public suspend fun consumerGroupReplications(vararg argument: suspend ReplicatorReplicationInfoListConsumerGroupReplicationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReplicatorReplicationInfoListConsumerGroupReplicationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.consumerGroupReplications = mapped
    }

    /**
     * @param argument Configuration relating to consumer group replication.
     */
    @JvmName("rjwxnfplegwpeyts")
    public suspend fun consumerGroupReplications(argument: suspend ReplicatorReplicationInfoListConsumerGroupReplicationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ReplicatorReplicationInfoListConsumerGroupReplicationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.consumerGroupReplications = mapped
    }

    /**
     * @param values Configuration relating to consumer group replication.
     */
    @JvmName("qnhhhsuofixdhivq")
    public suspend fun consumerGroupReplications(vararg values: ReplicatorReplicationInfoListConsumerGroupReplicationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.consumerGroupReplications = mapped
    }

    /**
     * @param value
     */
    @JvmName("anndkywheeqtnejb")
    public suspend fun sourceKafkaClusterAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceKafkaClusterAlias = mapped
    }

    /**
     * @param value The ARN of the source Kafka cluster.
     */
    @JvmName("rqpfbgvhdcvtweys")
    public suspend fun sourceKafkaClusterArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceKafkaClusterArn = mapped
    }

    /**
     * @param value The type of compression to use writing records to target Kafka cluster.
     */
    @JvmName("xmuvobtjgomhekrm")
    public suspend fun targetCompressionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetCompressionType = mapped
    }

    /**
     * @param value
     */
    @JvmName("euetkkmcihpolqsu")
    public suspend fun targetKafkaClusterAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetKafkaClusterAlias = mapped
    }

    /**
     * @param value The ARN of the target Kafka cluster.
     */
    @JvmName("lxjqayfwrbujcygj")
    public suspend fun targetKafkaClusterArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetKafkaClusterArn = mapped
    }

    /**
     * @param value Configuration relating to topic replication.
     */
    @JvmName("lchnaswisqjdfuro")
    public suspend fun topicReplications(`value`: List<ReplicatorReplicationInfoListTopicReplicationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicReplications = mapped
    }

    /**
     * @param argument Configuration relating to topic replication.
     */
    @JvmName("hqaqjogsjxyjiqfv")
    public suspend fun topicReplications(argument: List<suspend ReplicatorReplicationInfoListTopicReplicationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReplicatorReplicationInfoListTopicReplicationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.topicReplications = mapped
    }

    /**
     * @param argument Configuration relating to topic replication.
     */
    @JvmName("mxlywkljguijdpmb")
    public suspend fun topicReplications(vararg argument: suspend ReplicatorReplicationInfoListTopicReplicationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReplicatorReplicationInfoListTopicReplicationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.topicReplications = mapped
    }

    /**
     * @param argument Configuration relating to topic replication.
     */
    @JvmName("rdyxylxsursdtxah")
    public suspend fun topicReplications(argument: suspend ReplicatorReplicationInfoListTopicReplicationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ReplicatorReplicationInfoListTopicReplicationArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.topicReplications = mapped
    }

    /**
     * @param values Configuration relating to topic replication.
     */
    @JvmName("qdstrpnnphcrbwjb")
    public suspend fun topicReplications(vararg values: ReplicatorReplicationInfoListTopicReplicationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicReplications = mapped
    }

    internal fun build(): ReplicatorReplicationInfoListArgs = ReplicatorReplicationInfoListArgs(
        consumerGroupReplications = consumerGroupReplications ?: throw
            PulumiNullFieldException("consumerGroupReplications"),
        sourceKafkaClusterAlias = sourceKafkaClusterAlias,
        sourceKafkaClusterArn = sourceKafkaClusterArn ?: throw
            PulumiNullFieldException("sourceKafkaClusterArn"),
        targetCompressionType = targetCompressionType ?: throw
            PulumiNullFieldException("targetCompressionType"),
        targetKafkaClusterAlias = targetKafkaClusterAlias,
        targetKafkaClusterArn = targetKafkaClusterArn ?: throw
            PulumiNullFieldException("targetKafkaClusterArn"),
        topicReplications = topicReplications ?: throw PulumiNullFieldException("topicReplications"),
    )
}
