@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListConsumerGroupReplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property consumerGroupsToExcludes List of regular expression patterns indicating the consumer groups that should not be replicated.
 * @property consumerGroupsToReplicates List of regular expression patterns indicating the consumer groups to copy.
 * @property detectAndCopyNewConsumerGroups Whether to periodically check for new consumer groups.
 * @property synchroniseConsumerGroupOffsets Whether to periodically write the translated offsets to __consumer_offsets topic in target cluster.
 */
public data class ReplicatorReplicationInfoListConsumerGroupReplicationArgs(
    public val consumerGroupsToExcludes: Output<List<String>>? = null,
    public val consumerGroupsToReplicates: Output<List<String>>,
    public val detectAndCopyNewConsumerGroups: Output<Boolean>? = null,
    public val synchroniseConsumerGroupOffsets: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListConsumerGroupReplicationArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListConsumerGroupReplicationArgs =
        com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListConsumerGroupReplicationArgs.builder()
            .consumerGroupsToExcludes(
                consumerGroupsToExcludes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .consumerGroupsToReplicates(
                consumerGroupsToReplicates.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .detectAndCopyNewConsumerGroups(detectAndCopyNewConsumerGroups?.applyValue({ args0 -> args0 }))
            .synchroniseConsumerGroupOffsets(
                synchroniseConsumerGroupOffsets?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [ReplicatorReplicationInfoListConsumerGroupReplicationArgs].
 */
@PulumiTagMarker
public class ReplicatorReplicationInfoListConsumerGroupReplicationArgsBuilder internal constructor() {
    private var consumerGroupsToExcludes: Output<List<String>>? = null

    private var consumerGroupsToReplicates: Output<List<String>>? = null

    private var detectAndCopyNewConsumerGroups: Output<Boolean>? = null

    private var synchroniseConsumerGroupOffsets: Output<Boolean>? = null

    /**
     * @param value List of regular expression patterns indicating the consumer groups that should not be replicated.
     */
    @JvmName("yyigewiqnmjmxvqc")
    public suspend fun consumerGroupsToExcludes(`value`: Output<List<String>>) {
        this.consumerGroupsToExcludes = value
    }

    @JvmName("xfahknkfivdbrcfm")
    public suspend fun consumerGroupsToExcludes(vararg values: Output<String>) {
        this.consumerGroupsToExcludes = Output.all(values.asList())
    }

    /**
     * @param values List of regular expression patterns indicating the consumer groups that should not be replicated.
     */
    @JvmName("jxeftacjcvacelxy")
    public suspend fun consumerGroupsToExcludes(values: List<Output<String>>) {
        this.consumerGroupsToExcludes = Output.all(values)
    }

    /**
     * @param value List of regular expression patterns indicating the consumer groups to copy.
     */
    @JvmName("lhxhwftqblpfmobb")
    public suspend fun consumerGroupsToReplicates(`value`: Output<List<String>>) {
        this.consumerGroupsToReplicates = value
    }

    @JvmName("taohtqoilyjiouuy")
    public suspend fun consumerGroupsToReplicates(vararg values: Output<String>) {
        this.consumerGroupsToReplicates = Output.all(values.asList())
    }

    /**
     * @param values List of regular expression patterns indicating the consumer groups to copy.
     */
    @JvmName("nfgohvkcitieresf")
    public suspend fun consumerGroupsToReplicates(values: List<Output<String>>) {
        this.consumerGroupsToReplicates = Output.all(values)
    }

    /**
     * @param value Whether to periodically check for new consumer groups.
     */
    @JvmName("nsdleoggududvufe")
    public suspend fun detectAndCopyNewConsumerGroups(`value`: Output<Boolean>) {
        this.detectAndCopyNewConsumerGroups = value
    }

    /**
     * @param value Whether to periodically write the translated offsets to __consumer_offsets topic in target cluster.
     */
    @JvmName("joionoakwmnystie")
    public suspend fun synchroniseConsumerGroupOffsets(`value`: Output<Boolean>) {
        this.synchroniseConsumerGroupOffsets = value
    }

    /**
     * @param value List of regular expression patterns indicating the consumer groups that should not be replicated.
     */
    @JvmName("fiysvsynrkuoiwei")
    public suspend fun consumerGroupsToExcludes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroupsToExcludes = mapped
    }

    /**
     * @param values List of regular expression patterns indicating the consumer groups that should not be replicated.
     */
    @JvmName("aevmlowqxfvpkknl")
    public suspend fun consumerGroupsToExcludes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.consumerGroupsToExcludes = mapped
    }

    /**
     * @param value List of regular expression patterns indicating the consumer groups to copy.
     */
    @JvmName("twfxrqxciupmtdng")
    public suspend fun consumerGroupsToReplicates(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.consumerGroupsToReplicates = mapped
    }

    /**
     * @param values List of regular expression patterns indicating the consumer groups to copy.
     */
    @JvmName("gjmrfcwyygrspoam")
    public suspend fun consumerGroupsToReplicates(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.consumerGroupsToReplicates = mapped
    }

    /**
     * @param value Whether to periodically check for new consumer groups.
     */
    @JvmName("hycneeevxineogsi")
    public suspend fun detectAndCopyNewConsumerGroups(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectAndCopyNewConsumerGroups = mapped
    }

    /**
     * @param value Whether to periodically write the translated offsets to __consumer_offsets topic in target cluster.
     */
    @JvmName("idkkacxcvlhelhmb")
    public suspend fun synchroniseConsumerGroupOffsets(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.synchroniseConsumerGroupOffsets = mapped
    }

    internal fun build(): ReplicatorReplicationInfoListConsumerGroupReplicationArgs =
        ReplicatorReplicationInfoListConsumerGroupReplicationArgs(
            consumerGroupsToExcludes = consumerGroupsToExcludes,
            consumerGroupsToReplicates = consumerGroupsToReplicates ?: throw
                PulumiNullFieldException("consumerGroupsToReplicates"),
            detectAndCopyNewConsumerGroups = detectAndCopyNewConsumerGroups,
            synchroniseConsumerGroupOffsets = synchroniseConsumerGroupOffsets,
        )
}
