@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListTopicReplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property copyAccessControlListsForTopics Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
 * @property copyTopicConfigurations Whether to periodically configure remote topics to match their corresponding upstream topics.
 * @property detectAndCopyNewTopics Whether to periodically check for new topics and partitions.
 * @property startingPosition Configuration for specifying the position in the topics to start replicating from.
 * @property topicsToExcludes List of regular expression patterns indicating the topics that should not be replica.
 * @property topicsToReplicates List of regular expression patterns indicating the topics to copy.
 */
public data class ReplicatorReplicationInfoListTopicReplicationArgs(
    public val copyAccessControlListsForTopics: Output<Boolean>? = null,
    public val copyTopicConfigurations: Output<Boolean>? = null,
    public val detectAndCopyNewTopics: Output<Boolean>? = null,
    public val startingPosition: Output<ReplicatorReplicationInfoListTopicReplicationStartingPositionArgs>? = null,
    public val topicsToExcludes: Output<List<String>>? = null,
    public val topicsToReplicates: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListTopicReplicationArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListTopicReplicationArgs = com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListTopicReplicationArgs.builder()
        .copyAccessControlListsForTopics(copyAccessControlListsForTopics?.applyValue({ args0 -> args0 }))
        .copyTopicConfigurations(copyTopicConfigurations?.applyValue({ args0 -> args0 }))
        .detectAndCopyNewTopics(detectAndCopyNewTopics?.applyValue({ args0 -> args0 }))
        .startingPosition(startingPosition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .topicsToExcludes(topicsToExcludes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .topicsToReplicates(topicsToReplicates.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ReplicatorReplicationInfoListTopicReplicationArgs].
 */
@PulumiTagMarker
public class ReplicatorReplicationInfoListTopicReplicationArgsBuilder internal constructor() {
    private var copyAccessControlListsForTopics: Output<Boolean>? = null

    private var copyTopicConfigurations: Output<Boolean>? = null

    private var detectAndCopyNewTopics: Output<Boolean>? = null

    private var startingPosition:
        Output<ReplicatorReplicationInfoListTopicReplicationStartingPositionArgs>? = null

    private var topicsToExcludes: Output<List<String>>? = null

    private var topicsToReplicates: Output<List<String>>? = null

    /**
     * @param value Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
     */
    @JvmName("savukrwvnnsddkkc")
    public suspend fun copyAccessControlListsForTopics(`value`: Output<Boolean>) {
        this.copyAccessControlListsForTopics = value
    }

    /**
     * @param value Whether to periodically configure remote topics to match their corresponding upstream topics.
     */
    @JvmName("gmbhlqwlgqhbqvyp")
    public suspend fun copyTopicConfigurations(`value`: Output<Boolean>) {
        this.copyTopicConfigurations = value
    }

    /**
     * @param value Whether to periodically check for new topics and partitions.
     */
    @JvmName("kqiftxhgjcknilgh")
    public suspend fun detectAndCopyNewTopics(`value`: Output<Boolean>) {
        this.detectAndCopyNewTopics = value
    }

    /**
     * @param value Configuration for specifying the position in the topics to start replicating from.
     */
    @JvmName("huqjtqqylajujrgg")
    public suspend fun startingPosition(`value`: Output<ReplicatorReplicationInfoListTopicReplicationStartingPositionArgs>) {
        this.startingPosition = value
    }

    /**
     * @param value List of regular expression patterns indicating the topics that should not be replica.
     */
    @JvmName("oyovupadywrlbqoh")
    public suspend fun topicsToExcludes(`value`: Output<List<String>>) {
        this.topicsToExcludes = value
    }

    @JvmName("gseakrjxblfelipx")
    public suspend fun topicsToExcludes(vararg values: Output<String>) {
        this.topicsToExcludes = Output.all(values.asList())
    }

    /**
     * @param values List of regular expression patterns indicating the topics that should not be replica.
     */
    @JvmName("lqaaqhunxpsfdhir")
    public suspend fun topicsToExcludes(values: List<Output<String>>) {
        this.topicsToExcludes = Output.all(values)
    }

    /**
     * @param value List of regular expression patterns indicating the topics to copy.
     */
    @JvmName("nrkmckfdxcimqejo")
    public suspend fun topicsToReplicates(`value`: Output<List<String>>) {
        this.topicsToReplicates = value
    }

    @JvmName("uqbljulatyiewnjk")
    public suspend fun topicsToReplicates(vararg values: Output<String>) {
        this.topicsToReplicates = Output.all(values.asList())
    }

    /**
     * @param values List of regular expression patterns indicating the topics to copy.
     */
    @JvmName("jkrycnytrvsadsog")
    public suspend fun topicsToReplicates(values: List<Output<String>>) {
        this.topicsToReplicates = Output.all(values)
    }

    /**
     * @param value Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
     */
    @JvmName("tfjsqyvpwknfrurf")
    public suspend fun copyAccessControlListsForTopics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyAccessControlListsForTopics = mapped
    }

    /**
     * @param value Whether to periodically configure remote topics to match their corresponding upstream topics.
     */
    @JvmName("okauqqygpfihmubi")
    public suspend fun copyTopicConfigurations(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTopicConfigurations = mapped
    }

    /**
     * @param value Whether to periodically check for new topics and partitions.
     */
    @JvmName("pkvyvkkqeqspyghi")
    public suspend fun detectAndCopyNewTopics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectAndCopyNewTopics = mapped
    }

    /**
     * @param value Configuration for specifying the position in the topics to start replicating from.
     */
    @JvmName("kotqclbjplhfgkmo")
    public suspend fun startingPosition(`value`: ReplicatorReplicationInfoListTopicReplicationStartingPositionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startingPosition = mapped
    }

    /**
     * @param argument Configuration for specifying the position in the topics to start replicating from.
     */
    @JvmName("cyrorhjkrtgicjlo")
    public suspend fun startingPosition(argument: suspend ReplicatorReplicationInfoListTopicReplicationStartingPositionArgsBuilder.() -> Unit) {
        val toBeMapped =
            ReplicatorReplicationInfoListTopicReplicationStartingPositionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.startingPosition = mapped
    }

    /**
     * @param value List of regular expression patterns indicating the topics that should not be replica.
     */
    @JvmName("seftsbxrfnsydoyc")
    public suspend fun topicsToExcludes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicsToExcludes = mapped
    }

    /**
     * @param values List of regular expression patterns indicating the topics that should not be replica.
     */
    @JvmName("uvvnjujencuvncuq")
    public suspend fun topicsToExcludes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicsToExcludes = mapped
    }

    /**
     * @param value List of regular expression patterns indicating the topics to copy.
     */
    @JvmName("qfedrmvemfgjxkmk")
    public suspend fun topicsToReplicates(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicsToReplicates = mapped
    }

    /**
     * @param values List of regular expression patterns indicating the topics to copy.
     */
    @JvmName("iptlapipuuktpaod")
    public suspend fun topicsToReplicates(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicsToReplicates = mapped
    }

    internal fun build(): ReplicatorReplicationInfoListTopicReplicationArgs =
        ReplicatorReplicationInfoListTopicReplicationArgs(
            copyAccessControlListsForTopics = copyAccessControlListsForTopics,
            copyTopicConfigurations = copyTopicConfigurations,
            detectAndCopyNewTopics = detectAndCopyNewTopics,
            startingPosition = startingPosition,
            topicsToExcludes = topicsToExcludes,
            topicsToReplicates = topicsToReplicates ?: throw PulumiNullFieldException("topicsToReplicates"),
        )
}
