@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListTopicReplicationStartingPositionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type The type of replication starting position. Supports `LATEST` and `EARLIEST`.
 */
public data class ReplicatorReplicationInfoListTopicReplicationStartingPositionArgs(
    public val type: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListTopicReplicationStartingPositionArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListTopicReplicationStartingPositionArgs =
        com.pulumi.aws.msk.inputs.ReplicatorReplicationInfoListTopicReplicationStartingPositionArgs.builder()
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicatorReplicationInfoListTopicReplicationStartingPositionArgs].
 */
@PulumiTagMarker
public class ReplicatorReplicationInfoListTopicReplicationStartingPositionArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value The type of replication starting position. Supports `LATEST` and `EARLIEST`.
     */
    @JvmName("brskstajbuphkfpn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The type of replication starting position. Supports `LATEST` and `EARLIEST`.
     */
    @JvmName("turdxmvgqxifrbxm")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ReplicatorReplicationInfoListTopicReplicationStartingPositionArgs =
        ReplicatorReplicationInfoListTopicReplicationStartingPositionArgs(
            type = type,
        )
}
