@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property sasl Details for client authentication using SASL. See below.
 */
public data class ServerlessClusterClientAuthenticationArgs(
    public val sasl: Output<ServerlessClusterClientAuthenticationSaslArgs>,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationArgs =
        com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationArgs.builder()
            .sasl(sasl.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ServerlessClusterClientAuthenticationArgs].
 */
@PulumiTagMarker
public class ServerlessClusterClientAuthenticationArgsBuilder internal constructor() {
    private var sasl: Output<ServerlessClusterClientAuthenticationSaslArgs>? = null

    /**
     * @param value Details for client authentication using SASL. See below.
     */
    @JvmName("awgncwjqdwwutoic")
    public suspend fun sasl(`value`: Output<ServerlessClusterClientAuthenticationSaslArgs>) {
        this.sasl = value
    }

    /**
     * @param value Details for client authentication using SASL. See below.
     */
    @JvmName("schmbnsnfklolkal")
    public suspend fun sasl(`value`: ServerlessClusterClientAuthenticationSaslArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sasl = mapped
    }

    /**
     * @param argument Details for client authentication using SASL. See below.
     */
    @JvmName("ynnnleprfxybkuau")
    public suspend fun sasl(argument: suspend ServerlessClusterClientAuthenticationSaslArgsBuilder.() -> Unit) {
        val toBeMapped = ServerlessClusterClientAuthenticationSaslArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sasl = mapped
    }

    internal fun build(): ServerlessClusterClientAuthenticationArgs =
        ServerlessClusterClientAuthenticationArgs(
            sasl = sasl ?: throw PulumiNullFieldException("sasl"),
        )
}
