@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.inputs

import com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationSaslArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property iam Details for client authentication using IAM. See below.
 */
public data class ServerlessClusterClientAuthenticationSaslArgs(
    public val iam: Output<ServerlessClusterClientAuthenticationSaslIamArgs>,
) : ConvertibleToJava<com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationSaslArgs> {
    override fun toJava(): com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationSaslArgs =
        com.pulumi.aws.msk.inputs.ServerlessClusterClientAuthenticationSaslArgs.builder()
            .iam(iam.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ServerlessClusterClientAuthenticationSaslArgs].
 */
@PulumiTagMarker
public class ServerlessClusterClientAuthenticationSaslArgsBuilder internal constructor() {
    private var iam: Output<ServerlessClusterClientAuthenticationSaslIamArgs>? = null

    /**
     * @param value Details for client authentication using IAM. See below.
     */
    @JvmName("sdfhtjhfqbquhhyx")
    public suspend fun iam(`value`: Output<ServerlessClusterClientAuthenticationSaslIamArgs>) {
        this.iam = value
    }

    /**
     * @param value Details for client authentication using IAM. See below.
     */
    @JvmName("qctwjbnhjfsofltq")
    public suspend fun iam(`value`: ServerlessClusterClientAuthenticationSaslIamArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iam = mapped
    }

    /**
     * @param argument Details for client authentication using IAM. See below.
     */
    @JvmName("qldswgsgymqlcepi")
    public suspend fun iam(argument: suspend ServerlessClusterClientAuthenticationSaslIamArgsBuilder.() -> Unit) {
        val toBeMapped = ServerlessClusterClientAuthenticationSaslIamArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.iam = mapped
    }

    internal fun build(): ServerlessClusterClientAuthenticationSaslArgs =
        ServerlessClusterClientAuthenticationSaslArgs(
            iam = iam ?: throw PulumiNullFieldException("iam"),
        )
}
