@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property azDistribution The distribution of broker nodes across availability zones ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-model-brokerazdistribution)). Currently the only valid value is `DEFAULT`.
 * @property clientSubnets A list of subnets to connect to in client VPC ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-prop-brokernodegroupinfo-clientsubnets)).
 * @property connectivityInfo Information about the cluster access configuration. See below. For security reasons, you can't turn on public access while creating an MSK cluster. However, you can update an existing cluster to make it publicly accessible. You can also create a new cluster and then update it to make it publicly accessible ([documentation](https://docs.aws.amazon.com/msk/latest/developerguide/public-access.html)).
 * @property instanceType Specify the instance type to use for the kafka brokersE.g., kafka.m5.large. ([Pricing info](https://aws.amazon.com/msk/pricing/))
 * @property securityGroups A list of the security groups to associate with the elastic network interfaces to control who can communicate with the cluster.
 * @property storageInfo A block that contains information about storage volumes attached to MSK broker nodes. See below.
 */
public data class ClusterBrokerNodeGroupInfo(
    public val azDistribution: String? = null,
    public val clientSubnets: List<String>,
    public val connectivityInfo: ClusterBrokerNodeGroupInfoConnectivityInfo? = null,
    public val instanceType: String,
    public val securityGroups: List<String>,
    public val storageInfo: ClusterBrokerNodeGroupInfoStorageInfo? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ClusterBrokerNodeGroupInfo): ClusterBrokerNodeGroupInfo = ClusterBrokerNodeGroupInfo(
            azDistribution = javaType.azDistribution().map({ args0 -> args0 }).orElse(null),
            clientSubnets = javaType.clientSubnets().map({ args0 -> args0 }),
            connectivityInfo = javaType.connectivityInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.msk.kotlin.outputs.ClusterBrokerNodeGroupInfoConnectivityInfo.Companion.toKotlin(args0)
                })
            }).orElse(null),
            instanceType = javaType.instanceType(),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            storageInfo = javaType.storageInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.msk.kotlin.outputs.ClusterBrokerNodeGroupInfoStorageInfo.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
