@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property publicAccess Access control settings for brokers. See below.
 * @property vpcConnectivity VPC connectivity access control for brokers. See below.
 */
public data class ClusterBrokerNodeGroupInfoConnectivityInfo(
    public val publicAccess: ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccess? = null,
    public val vpcConnectivity: ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivity? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ClusterBrokerNodeGroupInfoConnectivityInfo): ClusterBrokerNodeGroupInfoConnectivityInfo = ClusterBrokerNodeGroupInfoConnectivityInfo(
            publicAccess = javaType.publicAccess().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.msk.kotlin.outputs.ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccess.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vpcConnectivity = javaType.vpcConnectivity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.msk.kotlin.outputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivity.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
