@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getBootstrapBrokers.
 * @property bootstrapBrokers Comma separated list of one or more hostname:port pairs of kafka brokers suitable to bootstrap connectivity to the kafka cluster.
 * @property bootstrapBrokersPublicSaslIam One or more DNS names (or IP addresses) and SASL IAM port pairs.
 * @property bootstrapBrokersPublicSaslScram One or more DNS names (or IP addresses) and SASL SCRAM port pairs.
 * @property bootstrapBrokersPublicTls One or more DNS names (or IP addresses) and TLS port pairs.
 * @property bootstrapBrokersSaslIam One or more DNS names (or IP addresses) and SASL IAM port pairs.
 * @property bootstrapBrokersSaslScram One or more DNS names (or IP addresses) and SASL SCRAM port pairs.
 * @property bootstrapBrokersTls One or more DNS names (or IP addresses) and TLS port pairs.
 * @property bootstrapBrokersVpcConnectivitySaslIam A string containing one or more DNS names (or IP addresses) and SASL IAM port pairs for VPC connectivity.
 * @property bootstrapBrokersVpcConnectivitySaslScram A string containing one or more DNS names (or IP addresses) and SASL SCRAM port pairs for VPC connectivity.
 * @property bootstrapBrokersVpcConnectivityTls A string containing one or more DNS names (or IP addresses) and TLS port pairs for VPC connectivity.
 * @property clusterArn
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetBootstrapBrokersResult(
    public val bootstrapBrokers: String,
    public val bootstrapBrokersPublicSaslIam: String,
    public val bootstrapBrokersPublicSaslScram: String,
    public val bootstrapBrokersPublicTls: String,
    public val bootstrapBrokersSaslIam: String,
    public val bootstrapBrokersSaslScram: String,
    public val bootstrapBrokersTls: String,
    public val bootstrapBrokersVpcConnectivitySaslIam: String,
    public val bootstrapBrokersVpcConnectivitySaslScram: String,
    public val bootstrapBrokersVpcConnectivityTls: String,
    public val clusterArn: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.GetBootstrapBrokersResult): GetBootstrapBrokersResult = GetBootstrapBrokersResult(
            bootstrapBrokers = javaType.bootstrapBrokers(),
            bootstrapBrokersPublicSaslIam = javaType.bootstrapBrokersPublicSaslIam(),
            bootstrapBrokersPublicSaslScram = javaType.bootstrapBrokersPublicSaslScram(),
            bootstrapBrokersPublicTls = javaType.bootstrapBrokersPublicTls(),
            bootstrapBrokersSaslIam = javaType.bootstrapBrokersSaslIam(),
            bootstrapBrokersSaslScram = javaType.bootstrapBrokersSaslScram(),
            bootstrapBrokersTls = javaType.bootstrapBrokersTls(),
            bootstrapBrokersVpcConnectivitySaslIam = javaType.bootstrapBrokersVpcConnectivitySaslIam(),
            bootstrapBrokersVpcConnectivitySaslScram = javaType.bootstrapBrokersVpcConnectivitySaslScram(),
            bootstrapBrokersVpcConnectivityTls = javaType.bootstrapBrokersVpcConnectivityTls(),
            clusterArn = javaType.clusterArn(),
            id = javaType.id(),
        )
    }
}
