@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property attachedEniId Attached elastic network interface of the broker
 * @property brokerId ID of the broker
 * @property clientSubnet Client subnet to which this broker node belongs
 * @property clientVpcIpAddress The client virtual private cloud (VPC) IP address
 * @property endpoints Set of endpoints for accessing the broker. This does not include ports
 * @property nodeArn ARN of the node
 */
public data class GetBrokerNodesNodeInfoList(
    public val attachedEniId: String,
    public val brokerId: Double,
    public val clientSubnet: String,
    public val clientVpcIpAddress: String,
    public val endpoints: List<String>,
    public val nodeArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.GetBrokerNodesNodeInfoList): GetBrokerNodesNodeInfoList = GetBrokerNodesNodeInfoList(
            attachedEniId = javaType.attachedEniId(),
            brokerId = javaType.brokerId(),
            clientSubnet = javaType.clientSubnet(),
            clientVpcIpAddress = javaType.clientVpcIpAddress(),
            endpoints = javaType.endpoints().map({ args0 -> args0 }),
            nodeArn = javaType.nodeArn(),
        )
    }
}
