@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property azDistribution
 * @property clientSubnets
 * @property connectivityInfos
 * @property instanceType
 * @property securityGroups
 * @property storageInfos
 */
public data class GetClusterBrokerNodeGroupInfo(
    public val azDistribution: String,
    public val clientSubnets: List<String>,
    public val connectivityInfos: List<GetClusterBrokerNodeGroupInfoConnectivityInfo>,
    public val instanceType: String,
    public val securityGroups: List<String>,
    public val storageInfos: List<GetClusterBrokerNodeGroupInfoStorageInfo>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.GetClusterBrokerNodeGroupInfo): GetClusterBrokerNodeGroupInfo = GetClusterBrokerNodeGroupInfo(
            azDistribution = javaType.azDistribution(),
            clientSubnets = javaType.clientSubnets().map({ args0 -> args0 }),
            connectivityInfos = javaType.connectivityInfos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.msk.kotlin.outputs.GetClusterBrokerNodeGroupInfoConnectivityInfo.Companion.toKotlin(args0)
                })
            }),
            instanceType = javaType.instanceType(),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            storageInfos = javaType.storageInfos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.msk.kotlin.outputs.GetClusterBrokerNodeGroupInfoStorageInfo.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
