@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getVpcConnection.
 * @property arn
 * @property authentication The authentication type for the client VPC Connection.
 * @property clientSubnets The list of subnets in the client VPC.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property securityGroups The security groups attached to the ENIs for the broker nodes.
 * @property tags Map of key-value pairs assigned to the VPC Connection.
 * @property targetClusterArn The Amazon Resource Name (ARN) of the cluster.
 * @property vpcId The VPC ID of the remote client.
 */
public data class GetVpcConnectionResult(
    public val arn: String,
    public val authentication: String,
    public val clientSubnets: List<String>,
    public val id: String,
    public val securityGroups: List<String>,
    public val tags: Map<String, String>,
    public val targetClusterArn: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.GetVpcConnectionResult): GetVpcConnectionResult = GetVpcConnectionResult(
            arn = javaType.arn(),
            authentication = javaType.authentication(),
            clientSubnets = javaType.clientSubnets().map({ args0 -> args0 }),
            id = javaType.id(),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetClusterArn = javaType.targetClusterArn(),
            vpcId = javaType.vpcId(),
        )
    }
}
