@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupsIds The AWS security groups to associate with the ENIs used by the replicator. If a security group is not specified, the default security group associated with the VPC is used.
 * @property subnetIds The list of subnets to connect to in the virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets to allow communication between your Kafka Cluster and the replicator.
 */
public data class ReplicatorKafkaClusterVpcConfig(
    public val securityGroupsIds: List<String>? = null,
    public val subnetIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ReplicatorKafkaClusterVpcConfig): ReplicatorKafkaClusterVpcConfig = ReplicatorKafkaClusterVpcConfig(
            securityGroupsIds = javaType.securityGroupsIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
        )
    }
}
