@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property consumerGroupReplications Configuration relating to consumer group replication.
 * @property sourceKafkaClusterAlias
 * @property sourceKafkaClusterArn The ARN of the source Kafka cluster.
 * @property targetCompressionType The type of compression to use writing records to target Kafka cluster.
 * @property targetKafkaClusterAlias
 * @property targetKafkaClusterArn The ARN of the target Kafka cluster.
 * @property topicReplications Configuration relating to topic replication.
 */
public data class ReplicatorReplicationInfoList(
    public val consumerGroupReplications: List<ReplicatorReplicationInfoListConsumerGroupReplication>,
    public val sourceKafkaClusterAlias: String? = null,
    public val sourceKafkaClusterArn: String,
    public val targetCompressionType: String,
    public val targetKafkaClusterAlias: String? = null,
    public val targetKafkaClusterArn: String,
    public val topicReplications: List<ReplicatorReplicationInfoListTopicReplication>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ReplicatorReplicationInfoList): ReplicatorReplicationInfoList = ReplicatorReplicationInfoList(
            consumerGroupReplications = javaType.consumerGroupReplications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.msk.kotlin.outputs.ReplicatorReplicationInfoListConsumerGroupReplication.Companion.toKotlin(args0)
                })
            }),
            sourceKafkaClusterAlias = javaType.sourceKafkaClusterAlias().map({ args0 -> args0 }).orElse(null),
            sourceKafkaClusterArn = javaType.sourceKafkaClusterArn(),
            targetCompressionType = javaType.targetCompressionType(),
            targetKafkaClusterAlias = javaType.targetKafkaClusterAlias().map({ args0 -> args0 }).orElse(null),
            targetKafkaClusterArn = javaType.targetKafkaClusterArn(),
            topicReplications = javaType.topicReplications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.msk.kotlin.outputs.ReplicatorReplicationInfoListTopicReplication.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
