@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.msk.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property consumerGroupsToExcludes List of regular expression patterns indicating the consumer groups that should not be replicated.
 * @property consumerGroupsToReplicates List of regular expression patterns indicating the consumer groups to copy.
 * @property detectAndCopyNewConsumerGroups Whether to periodically check for new consumer groups.
 * @property synchroniseConsumerGroupOffsets Whether to periodically write the translated offsets to __consumer_offsets topic in target cluster.
 */
public data class ReplicatorReplicationInfoListConsumerGroupReplication(
    public val consumerGroupsToExcludes: List<String>? = null,
    public val consumerGroupsToReplicates: List<String>,
    public val detectAndCopyNewConsumerGroups: Boolean? = null,
    public val synchroniseConsumerGroupOffsets: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.msk.outputs.ReplicatorReplicationInfoListConsumerGroupReplication): ReplicatorReplicationInfoListConsumerGroupReplication =
            ReplicatorReplicationInfoListConsumerGroupReplication(
                consumerGroupsToExcludes = javaType.consumerGroupsToExcludes().map({ args0 -> args0 }),
                consumerGroupsToReplicates = javaType.consumerGroupsToReplicates().map({ args0 -> args0 }),
                detectAndCopyNewConsumerGroups = javaType.detectAndCopyNewConsumerGroups().map({ args0 ->
                    args0
                }).orElse(null),
                synchroniseConsumerGroupOffsets = javaType.synchroniseConsumerGroupOffsets().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
