@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin

import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorCapacity
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorKafkaCluster
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorKafkaClusterClientAuthentication
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorKafkaClusterEncryptionInTransit
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorLogDelivery
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorPlugin
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorWorkerConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorCapacity.Companion.toKotlin as connectorCapacityToKotlin
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorKafkaCluster.Companion.toKotlin as connectorKafkaClusterToKotlin
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorKafkaClusterClientAuthentication.Companion.toKotlin as connectorKafkaClusterClientAuthenticationToKotlin
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorKafkaClusterEncryptionInTransit.Companion.toKotlin as connectorKafkaClusterEncryptionInTransitToKotlin
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorLogDelivery.Companion.toKotlin as connectorLogDeliveryToKotlin
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorPlugin.Companion.toKotlin as connectorPluginToKotlin
import com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorWorkerConfiguration.Companion.toKotlin as connectorWorkerConfigurationToKotlin

/**
 * Builder for [Connector].
 */
@PulumiTagMarker
public class ConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectorArgs = ConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectorArgsBuilder.() -> Unit) {
        val builder = ConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Connector {
        val builtJavaResource = com.pulumi.aws.mskconnect.Connector(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Connector(builtJavaResource)
    }
}

/**
 * Provides an Amazon MSK Connect Connector resource.
 * ## Example Usage
 * ### Basic configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.mskconnect.Connector("example", {
 *     name: "example",
 *     kafkaconnectVersion: "2.7.1",
 *     capacity: {
 *         autoscaling: {
 *             mcuCount: 1,
 *             minWorkerCount: 1,
 *             maxWorkerCount: 2,
 *             scaleInPolicy: {
 *                 cpuUtilizationPercentage: 20,
 *             },
 *             scaleOutPolicy: {
 *                 cpuUtilizationPercentage: 80,
 *             },
 *         },
 *     },
 *     connectorConfiguration: {
 *         "connector.class": "com.github.jcustenborder.kafka.connect.simulator.SimulatorSinkConnector",
 *         "tasks.max": "1",
 *         topics: "example",
 *     },
 *     kafkaCluster: {
 *         apacheKafkaCluster: {
 *             bootstrapServers: exampleAwsMskCluster.bootstrapBrokersTls,
 *             vpc: {
 *                 securityGroups: [exampleAwsSecurityGroup&#46;id],
 *                 subnets: [
 *                     example1.id,
 *                     example2.id,
 *                     example3.id,
 *                 ],
 *             },
 *         },
 *     },
 *     kafkaClusterClientAuthentication: {
 *         authenticationType: "NONE",
 *     },
 *     kafkaClusterEncryptionInTransit: {
 *         encryptionType: "TLS",
 *     },
 *     plugins: [{
 *         customPlugin: {
 *             arn: exampleAwsMskconnectCustomPlugin.arn,
 *             revision: exampleAwsMskconnectCustomPlugin.latestRevision,
 *         },
 *     }],
 *     serviceExecutionRoleArn: exampleAwsIamRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.mskconnect.Connector("example",
 *     name="example",
 *     kafkaconnect_version="2.7.1",
 *     capacity={
 *         "autoscaling": {
 *             "mcu_count": 1,
 *             "min_worker_count": 1,
 *             "max_worker_count": 2,
 *             "scale_in_policy": {
 *                 "cpu_utilization_percentage": 20,
 *             },
 *             "scale_out_policy": {
 *                 "cpu_utilization_percentage": 80,
 *             },
 *         },
 *     },
 *     connector_configuration={
 *         "connector.class": "com.github.jcustenborder.kafka.connect.simulator.SimulatorSinkConnector",
 *         "tasks.max": "1",
 *         "topics": "example",
 *     },
 *     kafka_cluster={
 *         "apache_kafka_cluster": {
 *             "bootstrap_servers": example_aws_msk_cluster["bootstrapBrokersTls"],
 *             "vpc": {
 *                 "security_groups": [example_aws_security_group["id"]],
 *                 "subnets": [
 *                     example1["id"],
 *                     example2["id"],
 *                     example3["id"],
 *                 ],
 *             },
 *         },
 *     },
 *     kafka_cluster_client_authentication={
 *         "authentication_type": "NONE",
 *     },
 *     kafka_cluster_encryption_in_transit={
 *         "encryption_type": "TLS",
 *     },
 *     plugins=[{
 *         "custom_plugin": {
 *             "arn": example_aws_mskconnect_custom_plugin["arn"],
 *             "revision": example_aws_mskconnect_custom_plugin["latestRevision"],
 *         },
 *     }],
 *     service_execution_role_arn=example_aws_iam_role["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.MskConnect.Connector("example", new()
 *     {
 *         Name = "example",
 *         KafkaconnectVersion = "2.7.1",
 *         Capacity = new Aws.MskConnect.Inputs.ConnectorCapacityArgs
 *         {
 *             Autoscaling = new Aws.MskConnect.Inputs.ConnectorCapacityAutoscalingArgs
 *             {
 *                 McuCount = 1,
 *                 MinWorkerCount = 1,
 *                 MaxWorkerCount = 2,
 *                 ScaleInPolicy = new Aws.MskConnect.Inputs.ConnectorCapacityAutoscalingScaleInPolicyArgs
 *                 {
 *                     CpuUtilizationPercentage = 20,
 *                 },
 *                 ScaleOutPolicy = new Aws.MskConnect.Inputs.ConnectorCapacityAutoscalingScaleOutPolicyArgs
 *                 {
 *                     CpuUtilizationPercentage = 80,
 *                 },
 *             },
 *         },
 *         ConnectorConfiguration =
 *         {
 *             { "connector.class", "com.github.jcustenborder.kafka.connect.simulator.SimulatorSinkConnector" },
 *             { "tasks.max", "1" },
 *             { "topics", "example" },
 *         },
 *         KafkaCluster = new Aws.MskConnect.Inputs.ConnectorKafkaClusterArgs
 *         {
 *             ApacheKafkaCluster = new Aws.MskConnect.Inputs.ConnectorKafkaClusterApacheKafkaClusterArgs
 *             {
 *                 BootstrapServers = exampleAwsMskCluster.BootstrapBrokersTls,
 *                 Vpc = new Aws.MskConnect.Inputs.ConnectorKafkaClusterApacheKafkaClusterVpcArgs
 *                 {
 *                     SecurityGroups = new[]
 *                     {
 *                         exampleAwsSecurityGroup.Id,
 *                     },
 *                     Subnets = new[]
 *                     {
 *                         example1.Id,
 *                         example2.Id,
 *                         example3.Id,
 *                     },
 *                 },
 *             },
 *         },
 *         KafkaClusterClientAuthentication = new Aws.MskConnect.Inputs.ConnectorKafkaClusterClientAuthenticationArgs
 *         {
 *             AuthenticationType = "NONE",
 *         },
 *         KafkaClusterEncryptionInTransit = new Aws.MskConnect.Inputs.ConnectorKafkaClusterEncryptionInTransitArgs
 *         {
 *             EncryptionType = "TLS",
 *         },
 *         Plugins = new[]
 *         {
 *             new Aws.MskConnect.Inputs.ConnectorPluginArgs
 *             {
 *                 CustomPlugin = new Aws.MskConnect.Inputs.ConnectorPluginCustomPluginArgs
 *                 {
 *                     Arn = exampleAwsMskconnectCustomPlugin.Arn,
 *                     Revision = exampleAwsMskconnectCustomPlugin.LatestRevision,
 *                 },
 *             },
 *         },
 *         ServiceExecutionRoleArn = exampleAwsIamRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mskconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mskconnect.NewConnector(ctx, "example", &mskconnect.ConnectorArgs{
 * 			Name:                pulumi.String("example"),
 * 			KafkaconnectVersion: pulumi.String("2.7.1"),
 * 			Capacity: &mskconnect.ConnectorCapacityArgs{
 * 				Autoscaling: &mskconnect.ConnectorCapacityAutoscalingArgs{
 * 					McuCount:       pulumi.Int(1),
 * 					MinWorkerCount: pulumi.Int(1),
 * 					MaxWorkerCount: pulumi.Int(2),
 * 					ScaleInPolicy: &mskconnect.ConnectorCapacityAutoscalingScaleInPolicyArgs{
 * 						CpuUtilizationPercentage: pulumi.Int(20),
 * 					},
 * 					ScaleOutPolicy: &mskconnect.ConnectorCapacityAutoscalingScaleOutPolicyArgs{
 * 						CpuUtilizationPercentage: pulumi.Int(80),
 * 					},
 * 				},
 * 			},
 * 			ConnectorConfiguration: pulumi.StringMap{
 * 				"connector.class": pulumi.String("com.github.jcustenborder.kafka.connect.simulator.SimulatorSinkConnector"),
 * 				"tasks.max":       pulumi.String("1"),
 * 				"topics":          pulumi.String("example"),
 * 			},
 * 			KafkaCluster: &mskconnect.ConnectorKafkaClusterArgs{
 * 				ApacheKafkaCluster: &mskconnect.ConnectorKafkaClusterApacheKafkaClusterArgs{
 * 					BootstrapServers: pulumi.Any(exampleAwsMskCluster.BootstrapBrokersTls),
 * 					Vpc: &mskconnect.ConnectorKafkaClusterApacheKafkaClusterVpcArgs{
 * 						SecurityGroups: pulumi.StringArray{
 * 							exampleAwsSecurityGroup.Id,
 * 						},
 * 						Subnets: pulumi.StringArray{
 * 							example1.Id,
 * 							example2.Id,
 * 							example3.Id,
 * 						},
 * 					},
 * 				},
 * 			},
 * 			KafkaClusterClientAuthentication: &mskconnect.ConnectorKafkaClusterClientAuthenticationArgs{
 * 				AuthenticationType: pulumi.String("NONE"),
 * 			},
 * 			KafkaClusterEncryptionInTransit: &mskconnect.ConnectorKafkaClusterEncryptionInTransitArgs{
 * 				EncryptionType: pulumi.String("TLS"),
 * 			},
 * 			Plugins: mskconnect.ConnectorPluginArray{
 * 				&mskconnect.ConnectorPluginArgs{
 * 					CustomPlugin: &mskconnect.ConnectorPluginCustomPluginArgs{
 * 						Arn:      pulumi.Any(exampleAwsMskconnectCustomPlugin.Arn),
 * 						Revision: pulumi.Any(exampleAwsMskconnectCustomPlugin.LatestRevision),
 * 					},
 * 				},
 * 			},
 * 			ServiceExecutionRoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mskconnect.Connector;
 * import com.pulumi.aws.mskconnect.ConnectorArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingScaleInPolicyArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingScaleOutPolicyArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterApacheKafkaClusterArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterApacheKafkaClusterVpcArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterClientAuthenticationArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterEncryptionInTransitArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorPluginArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorPluginCustomPluginArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connector("example", ConnectorArgs.builder()
 *             .name("example")
 *             .kafkaconnectVersion("2.7.1")
 *             .capacity(ConnectorCapacityArgs.builder()
 *                 .autoscaling(ConnectorCapacityAutoscalingArgs.builder()
 *                     .mcuCount(1)
 *                     .minWorkerCount(1)
 *                     .maxWorkerCount(2)
 *                     .scaleInPolicy(ConnectorCapacityAutoscalingScaleInPolicyArgs.builder()
 *                         .cpuUtilizationPercentage(20)
 *                         .build())
 *                     .scaleOutPolicy(ConnectorCapacityAutoscalingScaleOutPolicyArgs.builder()
 *                         .cpuUtilizationPercentage(80)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .connectorConfiguration(Map.ofEntries(
 *                 Map.entry("connector.class", "com.github.jcustenborder.kafka.connect.simulator.SimulatorSinkConnector"),
 *                 Map.entry("tasks.max", "1"),
 *                 Map.entry("topics", "example")
 *             ))
 *             .kafkaCluster(ConnectorKafkaClusterArgs.builder()
 *                 .apacheKafkaCluster(ConnectorKafkaClusterApacheKafkaClusterArgs.builder()
 *                     .bootstrapServers(exampleAwsMskCluster.bootstrapBrokersTls())
 *                     .vpc(ConnectorKafkaClusterApacheKafkaClusterVpcArgs.builder()
 *                         .securityGroups(exampleAwsSecurityGroup.id())
 *                         .subnets(
 *                             example1.id(),
 *                             example2.id(),
 *                             example3.id())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .kafkaClusterClientAuthentication(ConnectorKafkaClusterClientAuthenticationArgs.builder()
 *                 .authenticationType("NONE")
 *                 .build())
 *             .kafkaClusterEncryptionInTransit(ConnectorKafkaClusterEncryptionInTransitArgs.builder()
 *                 .encryptionType("TLS")
 *                 .build())
 *             .plugins(ConnectorPluginArgs.builder()
 *                 .customPlugin(ConnectorPluginCustomPluginArgs.builder()
 *                     .arn(exampleAwsMskconnectCustomPlugin.arn())
 *                     .revision(exampleAwsMskconnectCustomPlugin.latestRevision())
 *                     .build())
 *                 .build())
 *             .serviceExecutionRoleArn(exampleAwsIamRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:mskconnect:Connector
 *     properties:
 *       name: example
 *       kafkaconnectVersion: 2.7.1
 *       capacity:
 *         autoscaling:
 *           mcuCount: 1
 *           minWorkerCount: 1
 *           maxWorkerCount: 2
 *           scaleInPolicy:
 *             cpuUtilizationPercentage: 20
 *           scaleOutPolicy:
 *             cpuUtilizationPercentage: 80
 *       connectorConfiguration:
 *         connector.class: com.github.jcustenborder.kafka.connect.simulator.SimulatorSinkConnector
 *         tasks.max: '1'
 *         topics: example
 *       kafkaCluster:
 *         apacheKafkaCluster:
 *           bootstrapServers: ${exampleAwsMskCluster.bootstrapBrokersTls}
 *           vpc:
 *             securityGroups:
 *               - ${exampleAwsSecurityGroup.id}
 *             subnets:
 *               - ${example1.id}
 *               - ${example2.id}
 *               - ${example3.id}
 *       kafkaClusterClientAuthentication:
 *         authenticationType: NONE
 *       kafkaClusterEncryptionInTransit:
 *         encryptionType: TLS
 *       plugins:
 *         - customPlugin:
 *             arn: ${exampleAwsMskconnectCustomPlugin.arn}
 *             revision: ${exampleAwsMskconnectCustomPlugin.latestRevision}
 *       serviceExecutionRoleArn: ${exampleAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MSK Connect Connector using the connector's `arn`. For example:
 * ```sh
 * $ pulumi import aws:mskconnect/connector:Connector example 'arn:aws:kafkaconnect:eu-central-1:123456789012:connector/example/264edee4-17a3-412e-bd76-6681cfc93805-3'
 * ```
 */
public class Connector internal constructor(
    override val javaResource: com.pulumi.aws.mskconnect.Connector,
) : KotlinCustomResource(javaResource, ConnectorMapper) {
    /**
     * The Amazon Resource Name (ARN) of the connector.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Information about the capacity allocated to the connector. See `capacity` Block for details.
     */
    public val capacity: Output<ConnectorCapacity>
        get() = javaResource.capacity().applyValue({ args0 ->
            args0.let({ args0 ->
                connectorCapacityToKotlin(args0)
            })
        })

    /**
     * A map of keys to values that represent the configuration for the connector.
     */
    public val connectorConfiguration: Output<Map<String, String>>
        get() = javaResource.connectorConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A summary description of the connector.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies which Apache Kafka cluster to connect to. See `kafka_cluster` Block for details.
     */
    public val kafkaCluster: Output<ConnectorKafkaCluster>
        get() = javaResource.kafkaCluster().applyValue({ args0 ->
            args0.let({ args0 ->
                connectorKafkaClusterToKotlin(args0)
            })
        })

    /**
     * Details of the client authentication used by the Apache Kafka cluster. See `kafka_cluster_client_authentication` Block for details.
     */
    public val kafkaClusterClientAuthentication: Output<ConnectorKafkaClusterClientAuthentication>
        get() = javaResource.kafkaClusterClientAuthentication().applyValue({ args0 ->
            args0.let({ args0 ->
                connectorKafkaClusterClientAuthenticationToKotlin(args0)
            })
        })

    /**
     * Details of encryption in transit to the Apache Kafka cluster. See `kafka_cluster_encryption_in_transit` Block for details.
     */
    public val kafkaClusterEncryptionInTransit: Output<ConnectorKafkaClusterEncryptionInTransit>
        get() = javaResource.kafkaClusterEncryptionInTransit().applyValue({ args0 ->
            args0.let({ args0 ->
                connectorKafkaClusterEncryptionInTransitToKotlin(args0)
            })
        })

    /**
     * The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
     */
    public val kafkaconnectVersion: Output<String>
        get() = javaResource.kafkaconnectVersion().applyValue({ args0 -> args0 })

    /**
     * Details about log delivery. See `log_delivery` Block for details.
     */
    public val logDelivery: Output<ConnectorLogDelivery>?
        get() = javaResource.logDelivery().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    connectorLogDeliveryToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the connector.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies which plugins to use for the connector. See `plugin` Block for details.
     */
    public val plugins: Output<List<ConnectorPlugin>>
        get() = javaResource.plugins().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    connectorPluginToKotlin(args0)
                })
            })
        })

    /**
     * The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.
     * The following arguments are optional:
     */
    public val serviceExecutionRoleArn: Output<String>
        get() = javaResource.serviceExecutionRoleArn().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The current version of the connector.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })

    /**
     * Specifies which worker configuration to use with the connector. See `worker_configuration` Block for details.
     */
    public val workerConfiguration: Output<ConnectorWorkerConfiguration>?
        get() = javaResource.workerConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> connectorWorkerConfigurationToKotlin(args0) })
            }).orElse(null)
        })
}

public object ConnectorMapper : ResourceMapper<Connector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.mskconnect.Connector::class == javaResource::class

    override fun map(javaResource: Resource): Connector = Connector(
        javaResource as
            com.pulumi.aws.mskconnect.Connector,
    )
}

/**
 * @see [Connector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Connector].
 */
public suspend fun connector(name: String, block: suspend ConnectorResourceBuilder.() -> Unit): Connector {
    val builder = ConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Connector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connector(name: String): Connector {
    val builder = ConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
