@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin

import com.pulumi.aws.mskconnect.ConnectorArgs.builder
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorCapacityArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorCapacityArgsBuilder
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorKafkaClusterArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorKafkaClusterArgsBuilder
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorKafkaClusterClientAuthenticationArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorKafkaClusterClientAuthenticationArgsBuilder
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorKafkaClusterEncryptionInTransitArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorKafkaClusterEncryptionInTransitArgsBuilder
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorLogDeliveryArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorLogDeliveryArgsBuilder
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorPluginArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorPluginArgsBuilder
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorWorkerConfigurationArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.ConnectorWorkerConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon MSK Connect Connector resource.
 * ## Example Usage
 * ### Basic configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.mskconnect.Connector("example", {
 *     name: "example",
 *     kafkaconnectVersion: "2.7.1",
 *     capacity: {
 *         autoscaling: {
 *             mcuCount: 1,
 *             minWorkerCount: 1,
 *             maxWorkerCount: 2,
 *             scaleInPolicy: {
 *                 cpuUtilizationPercentage: 20,
 *             },
 *             scaleOutPolicy: {
 *                 cpuUtilizationPercentage: 80,
 *             },
 *         },
 *     },
 *     connectorConfiguration: {
 *         "connector.class": "com.github.jcustenborder.kafka.connect.simulator.SimulatorSinkConnector",
 *         "tasks.max": "1",
 *         topics: "example",
 *     },
 *     kafkaCluster: {
 *         apacheKafkaCluster: {
 *             bootstrapServers: exampleAwsMskCluster.bootstrapBrokersTls,
 *             vpc: {
 *                 securityGroups: [exampleAwsSecurityGroup&#46;id],
 *                 subnets: [
 *                     example1.id,
 *                     example2.id,
 *                     example3.id,
 *                 ],
 *             },
 *         },
 *     },
 *     kafkaClusterClientAuthentication: {
 *         authenticationType: "NONE",
 *     },
 *     kafkaClusterEncryptionInTransit: {
 *         encryptionType: "TLS",
 *     },
 *     plugins: [{
 *         customPlugin: {
 *             arn: exampleAwsMskconnectCustomPlugin.arn,
 *             revision: exampleAwsMskconnectCustomPlugin.latestRevision,
 *         },
 *     }],
 *     serviceExecutionRoleArn: exampleAwsIamRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.mskconnect.Connector("example",
 *     name="example",
 *     kafkaconnect_version="2.7.1",
 *     capacity={
 *         "autoscaling": {
 *             "mcu_count": 1,
 *             "min_worker_count": 1,
 *             "max_worker_count": 2,
 *             "scale_in_policy": {
 *                 "cpu_utilization_percentage": 20,
 *             },
 *             "scale_out_policy": {
 *                 "cpu_utilization_percentage": 80,
 *             },
 *         },
 *     },
 *     connector_configuration={
 *         "connector.class": "com.github.jcustenborder.kafka.connect.simulator.SimulatorSinkConnector",
 *         "tasks.max": "1",
 *         "topics": "example",
 *     },
 *     kafka_cluster={
 *         "apache_kafka_cluster": {
 *             "bootstrap_servers": example_aws_msk_cluster["bootstrapBrokersTls"],
 *             "vpc": {
 *                 "security_groups": [example_aws_security_group["id"]],
 *                 "subnets": [
 *                     example1["id"],
 *                     example2["id"],
 *                     example3["id"],
 *                 ],
 *             },
 *         },
 *     },
 *     kafka_cluster_client_authentication={
 *         "authentication_type": "NONE",
 *     },
 *     kafka_cluster_encryption_in_transit={
 *         "encryption_type": "TLS",
 *     },
 *     plugins=[{
 *         "custom_plugin": {
 *             "arn": example_aws_mskconnect_custom_plugin["arn"],
 *             "revision": example_aws_mskconnect_custom_plugin["latestRevision"],
 *         },
 *     }],
 *     service_execution_role_arn=example_aws_iam_role["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.MskConnect.Connector("example", new()
 *     {
 *         Name = "example",
 *         KafkaconnectVersion = "2.7.1",
 *         Capacity = new Aws.MskConnect.Inputs.ConnectorCapacityArgs
 *         {
 *             Autoscaling = new Aws.MskConnect.Inputs.ConnectorCapacityAutoscalingArgs
 *             {
 *                 McuCount = 1,
 *                 MinWorkerCount = 1,
 *                 MaxWorkerCount = 2,
 *                 ScaleInPolicy = new Aws.MskConnect.Inputs.ConnectorCapacityAutoscalingScaleInPolicyArgs
 *                 {
 *                     CpuUtilizationPercentage = 20,
 *                 },
 *                 ScaleOutPolicy = new Aws.MskConnect.Inputs.ConnectorCapacityAutoscalingScaleOutPolicyArgs
 *                 {
 *                     CpuUtilizationPercentage = 80,
 *                 },
 *             },
 *         },
 *         ConnectorConfiguration =
 *         {
 *             { "connector.class", "com.github.jcustenborder.kafka.connect.simulator.SimulatorSinkConnector" },
 *             { "tasks.max", "1" },
 *             { "topics", "example" },
 *         },
 *         KafkaCluster = new Aws.MskConnect.Inputs.ConnectorKafkaClusterArgs
 *         {
 *             ApacheKafkaCluster = new Aws.MskConnect.Inputs.ConnectorKafkaClusterApacheKafkaClusterArgs
 *             {
 *                 BootstrapServers = exampleAwsMskCluster.BootstrapBrokersTls,
 *                 Vpc = new Aws.MskConnect.Inputs.ConnectorKafkaClusterApacheKafkaClusterVpcArgs
 *                 {
 *                     SecurityGroups = new[]
 *                     {
 *                         exampleAwsSecurityGroup.Id,
 *                     },
 *                     Subnets = new[]
 *                     {
 *                         example1.Id,
 *                         example2.Id,
 *                         example3.Id,
 *                     },
 *                 },
 *             },
 *         },
 *         KafkaClusterClientAuthentication = new Aws.MskConnect.Inputs.ConnectorKafkaClusterClientAuthenticationArgs
 *         {
 *             AuthenticationType = "NONE",
 *         },
 *         KafkaClusterEncryptionInTransit = new Aws.MskConnect.Inputs.ConnectorKafkaClusterEncryptionInTransitArgs
 *         {
 *             EncryptionType = "TLS",
 *         },
 *         Plugins = new[]
 *         {
 *             new Aws.MskConnect.Inputs.ConnectorPluginArgs
 *             {
 *                 CustomPlugin = new Aws.MskConnect.Inputs.ConnectorPluginCustomPluginArgs
 *                 {
 *                     Arn = exampleAwsMskconnectCustomPlugin.Arn,
 *                     Revision = exampleAwsMskconnectCustomPlugin.LatestRevision,
 *                 },
 *             },
 *         },
 *         ServiceExecutionRoleArn = exampleAwsIamRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mskconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mskconnect.NewConnector(ctx, "example", &mskconnect.ConnectorArgs{
 * 			Name:                pulumi.String("example"),
 * 			KafkaconnectVersion: pulumi.String("2.7.1"),
 * 			Capacity: &mskconnect.ConnectorCapacityArgs{
 * 				Autoscaling: &mskconnect.ConnectorCapacityAutoscalingArgs{
 * 					McuCount:       pulumi.Int(1),
 * 					MinWorkerCount: pulumi.Int(1),
 * 					MaxWorkerCount: pulumi.Int(2),
 * 					ScaleInPolicy: &mskconnect.ConnectorCapacityAutoscalingScaleInPolicyArgs{
 * 						CpuUtilizationPercentage: pulumi.Int(20),
 * 					},
 * 					ScaleOutPolicy: &mskconnect.ConnectorCapacityAutoscalingScaleOutPolicyArgs{
 * 						CpuUtilizationPercentage: pulumi.Int(80),
 * 					},
 * 				},
 * 			},
 * 			ConnectorConfiguration: pulumi.StringMap{
 * 				"connector.class": pulumi.String("com.github.jcustenborder.kafka.connect.simulator.SimulatorSinkConnector"),
 * 				"tasks.max":       pulumi.String("1"),
 * 				"topics":          pulumi.String("example"),
 * 			},
 * 			KafkaCluster: &mskconnect.ConnectorKafkaClusterArgs{
 * 				ApacheKafkaCluster: &mskconnect.ConnectorKafkaClusterApacheKafkaClusterArgs{
 * 					BootstrapServers: pulumi.Any(exampleAwsMskCluster.BootstrapBrokersTls),
 * 					Vpc: &mskconnect.ConnectorKafkaClusterApacheKafkaClusterVpcArgs{
 * 						SecurityGroups: pulumi.StringArray{
 * 							exampleAwsSecurityGroup.Id,
 * 						},
 * 						Subnets: pulumi.StringArray{
 * 							example1.Id,
 * 							example2.Id,
 * 							example3.Id,
 * 						},
 * 					},
 * 				},
 * 			},
 * 			KafkaClusterClientAuthentication: &mskconnect.ConnectorKafkaClusterClientAuthenticationArgs{
 * 				AuthenticationType: pulumi.String("NONE"),
 * 			},
 * 			KafkaClusterEncryptionInTransit: &mskconnect.ConnectorKafkaClusterEncryptionInTransitArgs{
 * 				EncryptionType: pulumi.String("TLS"),
 * 			},
 * 			Plugins: mskconnect.ConnectorPluginArray{
 * 				&mskconnect.ConnectorPluginArgs{
 * 					CustomPlugin: &mskconnect.ConnectorPluginCustomPluginArgs{
 * 						Arn:      pulumi.Any(exampleAwsMskconnectCustomPlugin.Arn),
 * 						Revision: pulumi.Any(exampleAwsMskconnectCustomPlugin.LatestRevision),
 * 					},
 * 				},
 * 			},
 * 			ServiceExecutionRoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mskconnect.Connector;
 * import com.pulumi.aws.mskconnect.ConnectorArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingScaleInPolicyArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingScaleOutPolicyArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterApacheKafkaClusterArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterApacheKafkaClusterVpcArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterClientAuthenticationArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterEncryptionInTransitArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorPluginArgs;
 * import com.pulumi.aws.mskconnect.inputs.ConnectorPluginCustomPluginArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connector("example", ConnectorArgs.builder()
 *             .name("example")
 *             .kafkaconnectVersion("2.7.1")
 *             .capacity(ConnectorCapacityArgs.builder()
 *                 .autoscaling(ConnectorCapacityAutoscalingArgs.builder()
 *                     .mcuCount(1)
 *                     .minWorkerCount(1)
 *                     .maxWorkerCount(2)
 *                     .scaleInPolicy(ConnectorCapacityAutoscalingScaleInPolicyArgs.builder()
 *                         .cpuUtilizationPercentage(20)
 *                         .build())
 *                     .scaleOutPolicy(ConnectorCapacityAutoscalingScaleOutPolicyArgs.builder()
 *                         .cpuUtilizationPercentage(80)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .connectorConfiguration(Map.ofEntries(
 *                 Map.entry("connector.class", "com.github.jcustenborder.kafka.connect.simulator.SimulatorSinkConnector"),
 *                 Map.entry("tasks.max", "1"),
 *                 Map.entry("topics", "example")
 *             ))
 *             .kafkaCluster(ConnectorKafkaClusterArgs.builder()
 *                 .apacheKafkaCluster(ConnectorKafkaClusterApacheKafkaClusterArgs.builder()
 *                     .bootstrapServers(exampleAwsMskCluster.bootstrapBrokersTls())
 *                     .vpc(ConnectorKafkaClusterApacheKafkaClusterVpcArgs.builder()
 *                         .securityGroups(exampleAwsSecurityGroup.id())
 *                         .subnets(
 *                             example1.id(),
 *                             example2.id(),
 *                             example3.id())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .kafkaClusterClientAuthentication(ConnectorKafkaClusterClientAuthenticationArgs.builder()
 *                 .authenticationType("NONE")
 *                 .build())
 *             .kafkaClusterEncryptionInTransit(ConnectorKafkaClusterEncryptionInTransitArgs.builder()
 *                 .encryptionType("TLS")
 *                 .build())
 *             .plugins(ConnectorPluginArgs.builder()
 *                 .customPlugin(ConnectorPluginCustomPluginArgs.builder()
 *                     .arn(exampleAwsMskconnectCustomPlugin.arn())
 *                     .revision(exampleAwsMskconnectCustomPlugin.latestRevision())
 *                     .build())
 *                 .build())
 *             .serviceExecutionRoleArn(exampleAwsIamRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:mskconnect:Connector
 *     properties:
 *       name: example
 *       kafkaconnectVersion: 2.7.1
 *       capacity:
 *         autoscaling:
 *           mcuCount: 1
 *           minWorkerCount: 1
 *           maxWorkerCount: 2
 *           scaleInPolicy:
 *             cpuUtilizationPercentage: 20
 *           scaleOutPolicy:
 *             cpuUtilizationPercentage: 80
 *       connectorConfiguration:
 *         connector.class: com.github.jcustenborder.kafka.connect.simulator.SimulatorSinkConnector
 *         tasks.max: '1'
 *         topics: example
 *       kafkaCluster:
 *         apacheKafkaCluster:
 *           bootstrapServers: ${exampleAwsMskCluster.bootstrapBrokersTls}
 *           vpc:
 *             securityGroups:
 *               - ${exampleAwsSecurityGroup.id}
 *             subnets:
 *               - ${example1.id}
 *               - ${example2.id}
 *               - ${example3.id}
 *       kafkaClusterClientAuthentication:
 *         authenticationType: NONE
 *       kafkaClusterEncryptionInTransit:
 *         encryptionType: TLS
 *       plugins:
 *         - customPlugin:
 *             arn: ${exampleAwsMskconnectCustomPlugin.arn}
 *             revision: ${exampleAwsMskconnectCustomPlugin.latestRevision}
 *       serviceExecutionRoleArn: ${exampleAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MSK Connect Connector using the connector's `arn`. For example:
 * ```sh
 * $ pulumi import aws:mskconnect/connector:Connector example 'arn:aws:kafkaconnect:eu-central-1:123456789012:connector/example/264edee4-17a3-412e-bd76-6681cfc93805-3'
 * ```
 * @property capacity Information about the capacity allocated to the connector. See `capacity` Block for details.
 * @property connectorConfiguration A map of keys to values that represent the configuration for the connector.
 * @property description A summary description of the connector.
 * @property kafkaCluster Specifies which Apache Kafka cluster to connect to. See `kafka_cluster` Block for details.
 * @property kafkaClusterClientAuthentication Details of the client authentication used by the Apache Kafka cluster. See `kafka_cluster_client_authentication` Block for details.
 * @property kafkaClusterEncryptionInTransit Details of encryption in transit to the Apache Kafka cluster. See `kafka_cluster_encryption_in_transit` Block for details.
 * @property kafkaconnectVersion The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
 * @property logDelivery Details about log delivery. See `log_delivery` Block for details.
 * @property name The name of the connector.
 * @property plugins Specifies which plugins to use for the connector. See `plugin` Block for details.
 * @property serviceExecutionRoleArn The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.
 * The following arguments are optional:
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property workerConfiguration Specifies which worker configuration to use with the connector. See `worker_configuration` Block for details.
 */
public data class ConnectorArgs(
    public val capacity: Output<ConnectorCapacityArgs>? = null,
    public val connectorConfiguration: Output<Map<String, String>>? = null,
    public val description: Output<String>? = null,
    public val kafkaCluster: Output<ConnectorKafkaClusterArgs>? = null,
    public val kafkaClusterClientAuthentication: Output<ConnectorKafkaClusterClientAuthenticationArgs>? = null,
    public val kafkaClusterEncryptionInTransit: Output<ConnectorKafkaClusterEncryptionInTransitArgs>? =
        null,
    public val kafkaconnectVersion: Output<String>? = null,
    public val logDelivery: Output<ConnectorLogDeliveryArgs>? = null,
    public val name: Output<String>? = null,
    public val plugins: Output<List<ConnectorPluginArgs>>? = null,
    public val serviceExecutionRoleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workerConfiguration: Output<ConnectorWorkerConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.ConnectorArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.ConnectorArgs =
        com.pulumi.aws.mskconnect.ConnectorArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectorConfiguration(
                connectorConfiguration?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .kafkaCluster(kafkaCluster?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kafkaClusterClientAuthentication(
                kafkaClusterClientAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .kafkaClusterEncryptionInTransit(
                kafkaClusterEncryptionInTransit?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .kafkaconnectVersion(kafkaconnectVersion?.applyValue({ args0 -> args0 }))
            .logDelivery(logDelivery?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .plugins(
                plugins?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .serviceExecutionRoleArn(serviceExecutionRoleArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workerConfiguration(
                workerConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectorArgs].
 */
@PulumiTagMarker
public class ConnectorArgsBuilder internal constructor() {
    private var capacity: Output<ConnectorCapacityArgs>? = null

    private var connectorConfiguration: Output<Map<String, String>>? = null

    private var description: Output<String>? = null

    private var kafkaCluster: Output<ConnectorKafkaClusterArgs>? = null

    private var kafkaClusterClientAuthentication:
        Output<ConnectorKafkaClusterClientAuthenticationArgs>? = null

    private var kafkaClusterEncryptionInTransit: Output<ConnectorKafkaClusterEncryptionInTransitArgs>? =
        null

    private var kafkaconnectVersion: Output<String>? = null

    private var logDelivery: Output<ConnectorLogDeliveryArgs>? = null

    private var name: Output<String>? = null

    private var plugins: Output<List<ConnectorPluginArgs>>? = null

    private var serviceExecutionRoleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workerConfiguration: Output<ConnectorWorkerConfigurationArgs>? = null

    /**
     * @param value Information about the capacity allocated to the connector. See `capacity` Block for details.
     */
    @JvmName("uwkfvywpdysmthkn")
    public suspend fun capacity(`value`: Output<ConnectorCapacityArgs>) {
        this.capacity = value
    }

    /**
     * @param value A map of keys to values that represent the configuration for the connector.
     */
    @JvmName("khoccyiumnspkeno")
    public suspend fun connectorConfiguration(`value`: Output<Map<String, String>>) {
        this.connectorConfiguration = value
    }

    /**
     * @param value A summary description of the connector.
     */
    @JvmName("fbmndqvtnxxunevy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies which Apache Kafka cluster to connect to. See `kafka_cluster` Block for details.
     */
    @JvmName("kistfkbvgujhplfl")
    public suspend fun kafkaCluster(`value`: Output<ConnectorKafkaClusterArgs>) {
        this.kafkaCluster = value
    }

    /**
     * @param value Details of the client authentication used by the Apache Kafka cluster. See `kafka_cluster_client_authentication` Block for details.
     */
    @JvmName("tnwpwcpxxdhuhgvt")
    public suspend fun kafkaClusterClientAuthentication(`value`: Output<ConnectorKafkaClusterClientAuthenticationArgs>) {
        this.kafkaClusterClientAuthentication = value
    }

    /**
     * @param value Details of encryption in transit to the Apache Kafka cluster. See `kafka_cluster_encryption_in_transit` Block for details.
     */
    @JvmName("yexpmexirmaylkjh")
    public suspend fun kafkaClusterEncryptionInTransit(`value`: Output<ConnectorKafkaClusterEncryptionInTransitArgs>) {
        this.kafkaClusterEncryptionInTransit = value
    }

    /**
     * @param value The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
     */
    @JvmName("kvlyddgowhebgvuy")
    public suspend fun kafkaconnectVersion(`value`: Output<String>) {
        this.kafkaconnectVersion = value
    }

    /**
     * @param value Details about log delivery. See `log_delivery` Block for details.
     */
    @JvmName("mmjxowwxfovtvjod")
    public suspend fun logDelivery(`value`: Output<ConnectorLogDeliveryArgs>) {
        this.logDelivery = value
    }

    /**
     * @param value The name of the connector.
     */
    @JvmName("xlqooqgpbnbeatsd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies which plugins to use for the connector. See `plugin` Block for details.
     */
    @JvmName("nmqltkscddtahvva")
    public suspend fun plugins(`value`: Output<List<ConnectorPluginArgs>>) {
        this.plugins = value
    }

    @JvmName("uceaewdrfwtdqeeg")
    public suspend fun plugins(vararg values: Output<ConnectorPluginArgs>) {
        this.plugins = Output.all(values.asList())
    }

    /**
     * @param values Specifies which plugins to use for the connector. See `plugin` Block for details.
     */
    @JvmName("swvxuahkhtmchjrp")
    public suspend fun plugins(values: List<Output<ConnectorPluginArgs>>) {
        this.plugins = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.
     * The following arguments are optional:
     */
    @JvmName("gbpdhxegiydpkytw")
    public suspend fun serviceExecutionRoleArn(`value`: Output<String>) {
        this.serviceExecutionRoleArn = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mtlpfxyadxieuhfn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies which worker configuration to use with the connector. See `worker_configuration` Block for details.
     */
    @JvmName("tpauscttsnviokbj")
    public suspend fun workerConfiguration(`value`: Output<ConnectorWorkerConfigurationArgs>) {
        this.workerConfiguration = value
    }

    /**
     * @param value Information about the capacity allocated to the connector. See `capacity` Block for details.
     */
    @JvmName("ewhusspfjofoguga")
    public suspend fun capacity(`value`: ConnectorCapacityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param argument Information about the capacity allocated to the connector. See `capacity` Block for details.
     */
    @JvmName("ibdfkvxbqthsnbkm")
    public suspend fun capacity(argument: suspend ConnectorCapacityArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorCapacityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.capacity = mapped
    }

    /**
     * @param value A map of keys to values that represent the configuration for the connector.
     */
    @JvmName("oqnemgvmiqflkivi")
    public suspend fun connectorConfiguration(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorConfiguration = mapped
    }

    /**
     * @param values A map of keys to values that represent the configuration for the connector.
     */
    @JvmName("pnhmmhahisrpdmry")
    public fun connectorConfiguration(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectorConfiguration = mapped
    }

    /**
     * @param value A summary description of the connector.
     */
    @JvmName("jfjshvveuwsclkwq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies which Apache Kafka cluster to connect to. See `kafka_cluster` Block for details.
     */
    @JvmName("gfwsywcvpgymjtrm")
    public suspend fun kafkaCluster(`value`: ConnectorKafkaClusterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaCluster = mapped
    }

    /**
     * @param argument Specifies which Apache Kafka cluster to connect to. See `kafka_cluster` Block for details.
     */
    @JvmName("askhtvypyfedmbvr")
    public suspend fun kafkaCluster(argument: suspend ConnectorKafkaClusterArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorKafkaClusterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kafkaCluster = mapped
    }

    /**
     * @param value Details of the client authentication used by the Apache Kafka cluster. See `kafka_cluster_client_authentication` Block for details.
     */
    @JvmName("ijwldwqlrxnwtykb")
    public suspend fun kafkaClusterClientAuthentication(`value`: ConnectorKafkaClusterClientAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaClusterClientAuthentication = mapped
    }

    /**
     * @param argument Details of the client authentication used by the Apache Kafka cluster. See `kafka_cluster_client_authentication` Block for details.
     */
    @JvmName("vkdulwjnqqfdlevm")
    public suspend fun kafkaClusterClientAuthentication(argument: suspend ConnectorKafkaClusterClientAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorKafkaClusterClientAuthenticationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kafkaClusterClientAuthentication = mapped
    }

    /**
     * @param value Details of encryption in transit to the Apache Kafka cluster. See `kafka_cluster_encryption_in_transit` Block for details.
     */
    @JvmName("dysbioqeplswailt")
    public suspend fun kafkaClusterEncryptionInTransit(`value`: ConnectorKafkaClusterEncryptionInTransitArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaClusterEncryptionInTransit = mapped
    }

    /**
     * @param argument Details of encryption in transit to the Apache Kafka cluster. See `kafka_cluster_encryption_in_transit` Block for details.
     */
    @JvmName("ogaymqhvmbsydned")
    public suspend fun kafkaClusterEncryptionInTransit(argument: suspend ConnectorKafkaClusterEncryptionInTransitArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorKafkaClusterEncryptionInTransitArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kafkaClusterEncryptionInTransit = mapped
    }

    /**
     * @param value The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
     */
    @JvmName("bngcoqfygjlgdtcu")
    public suspend fun kafkaconnectVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaconnectVersion = mapped
    }

    /**
     * @param value Details about log delivery. See `log_delivery` Block for details.
     */
    @JvmName("uqpjbvkyhqdkfykg")
    public suspend fun logDelivery(`value`: ConnectorLogDeliveryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logDelivery = mapped
    }

    /**
     * @param argument Details about log delivery. See `log_delivery` Block for details.
     */
    @JvmName("kwfywhjkpnqfhxui")
    public suspend fun logDelivery(argument: suspend ConnectorLogDeliveryArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorLogDeliveryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logDelivery = mapped
    }

    /**
     * @param value The name of the connector.
     */
    @JvmName("ngsxgbfigmqxeswk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies which plugins to use for the connector. See `plugin` Block for details.
     */
    @JvmName("dlpnkecvmrohorus")
    public suspend fun plugins(`value`: List<ConnectorPluginArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plugins = mapped
    }

    /**
     * @param argument Specifies which plugins to use for the connector. See `plugin` Block for details.
     */
    @JvmName("bwgyhlplthjxxpgc")
    public suspend fun plugins(argument: List<suspend ConnectorPluginArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectorPluginArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.plugins = mapped
    }

    /**
     * @param argument Specifies which plugins to use for the connector. See `plugin` Block for details.
     */
    @JvmName("qrxhdefcgjheuhux")
    public suspend fun plugins(vararg argument: suspend ConnectorPluginArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConnectorPluginArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.plugins = mapped
    }

    /**
     * @param argument Specifies which plugins to use for the connector. See `plugin` Block for details.
     */
    @JvmName("lqkfsncuwjgbqdfu")
    public suspend fun plugins(argument: suspend ConnectorPluginArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ConnectorPluginArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.plugins = mapped
    }

    /**
     * @param values Specifies which plugins to use for the connector. See `plugin` Block for details.
     */
    @JvmName("knfbwyxvpjdrqkiv")
    public suspend fun plugins(vararg values: ConnectorPluginArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.plugins = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.
     * The following arguments are optional:
     */
    @JvmName("ftchawvwciabtjti")
    public suspend fun serviceExecutionRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceExecutionRoleArn = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cmxknrrrmesnegmj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ntxcweohxavfjjyv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies which worker configuration to use with the connector. See `worker_configuration` Block for details.
     */
    @JvmName("rbmdicuciufhfsuf")
    public suspend fun workerConfiguration(`value`: ConnectorWorkerConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerConfiguration = mapped
    }

    /**
     * @param argument Specifies which worker configuration to use with the connector. See `worker_configuration` Block for details.
     */
    @JvmName("omcwhdinjblopdao")
    public suspend fun workerConfiguration(argument: suspend ConnectorWorkerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorWorkerConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.workerConfiguration = mapped
    }

    internal fun build(): ConnectorArgs = ConnectorArgs(
        capacity = capacity,
        connectorConfiguration = connectorConfiguration,
        description = description,
        kafkaCluster = kafkaCluster,
        kafkaClusterClientAuthentication = kafkaClusterClientAuthentication,
        kafkaClusterEncryptionInTransit = kafkaClusterEncryptionInTransit,
        kafkaconnectVersion = kafkaconnectVersion,
        logDelivery = logDelivery,
        name = name,
        plugins = plugins,
        serviceExecutionRoleArn = serviceExecutionRoleArn,
        tags = tags,
        workerConfiguration = workerConfiguration,
    )
}
