@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin

import com.pulumi.aws.mskconnect.kotlin.outputs.CustomPluginLocation
import com.pulumi.aws.mskconnect.kotlin.outputs.CustomPluginLocation.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [CustomPlugin].
 */
@PulumiTagMarker
public class CustomPluginResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomPluginArgs = CustomPluginArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomPluginArgsBuilder.() -> Unit) {
        val builder = CustomPluginArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CustomPlugin {
        val builtJavaResource = com.pulumi.aws.mskconnect.CustomPlugin(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomPlugin(builtJavaResource)
    }
}

/**
 * Provides an Amazon MSK Connect Custom Plugin Resource.
 * ## Example Usage
 * ### Basic configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {bucket: "example"});
 * const exampleBucketObjectv2 = new aws.s3.BucketObjectv2("example", {
 *     bucket: example.id,
 *     key: "debezium.zip",
 *     source: new pulumi.asset.FileAsset("debezium.zip"),
 * });
 * const exampleCustomPlugin = new aws.mskconnect.CustomPlugin("example", {
 *     name: "debezium-example",
 *     contentType: "ZIP",
 *     location: {
 *         s3: {
 *             bucketArn: example.arn,
 *             fileKey: exampleBucketObjectv2.key,
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example", bucket="example")
 * example_bucket_objectv2 = aws.s3.BucketObjectv2("example",
 *     bucket=example.id,
 *     key="debezium.zip",
 *     source=pulumi.FileAsset("debezium.zip"))
 * example_custom_plugin = aws.mskconnect.CustomPlugin("example",
 *     name="debezium-example",
 *     content_type="ZIP",
 *     location={
 *         "s3": {
 *             "bucket_arn": example.arn,
 *             "file_key": example_bucket_objectv2.key,
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var exampleBucketObjectv2 = new Aws.S3.BucketObjectv2("example", new()
 *     {
 *         Bucket = example.Id,
 *         Key = "debezium.zip",
 *         Source = new FileAsset("debezium.zip"),
 *     });
 *     var exampleCustomPlugin = new Aws.MskConnect.CustomPlugin("example", new()
 *     {
 *         Name = "debezium-example",
 *         ContentType = "ZIP",
 *         Location = new Aws.MskConnect.Inputs.CustomPluginLocationArgs
 *         {
 *             S3 = new Aws.MskConnect.Inputs.CustomPluginLocationS3Args
 *             {
 *                 BucketArn = example.Arn,
 *                 FileKey = exampleBucketObjectv2.Key,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mskconnect"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleBucketObjectv2, err := s3.NewBucketObjectv2(ctx, "example", &s3.BucketObjectv2Args{
 * 			Bucket: example.ID(),
 * 			Key:    pulumi.String("debezium.zip"),
 * 			Source: pulumi.NewFileAsset("debezium.zip"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = mskconnect.NewCustomPlugin(ctx, "example", &mskconnect.CustomPluginArgs{
 * 			Name:        pulumi.String("debezium-example"),
 * 			ContentType: pulumi.String("ZIP"),
 * 			Location: &mskconnect.CustomPluginLocationArgs{
 * 				S3: &mskconnect.CustomPluginLocationS3Args{
 * 					BucketArn: example.Arn,
 * 					FileKey:   exampleBucketObjectv2.Key,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.mskconnect.CustomPlugin;
 * import com.pulumi.aws.mskconnect.CustomPluginArgs;
 * import com.pulumi.aws.mskconnect.inputs.CustomPluginLocationArgs;
 * import com.pulumi.aws.mskconnect.inputs.CustomPluginLocationS3Args;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var exampleBucketObjectv2 = new BucketObjectv2("exampleBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(example.id())
 *             .key("debezium.zip")
 *             .source(new FileAsset("debezium.zip"))
 *             .build());
 *         var exampleCustomPlugin = new CustomPlugin("exampleCustomPlugin", CustomPluginArgs.builder()
 *             .name("debezium-example")
 *             .contentType("ZIP")
 *             .location(CustomPluginLocationArgs.builder()
 *                 .s3(CustomPluginLocationS3Args.builder()
 *                     .bucketArn(example.arn())
 *                     .fileKey(exampleBucketObjectv2.key())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example
 *   exampleBucketObjectv2:
 *     type: aws:s3:BucketObjectv2
 *     name: example
 *     properties:
 *       bucket: ${example.id}
 *       key: debezium.zip
 *       source:
 *         fn::FileAsset: debezium.zip
 *   exampleCustomPlugin:
 *     type: aws:mskconnect:CustomPlugin
 *     name: example
 *     properties:
 *       name: debezium-example
 *       contentType: ZIP
 *       location:
 *         s3:
 *           bucketArn: ${example.arn}
 *           fileKey: ${exampleBucketObjectv2.key}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MSK Connect Custom Plugin using the plugin's `arn`. For example:
 * ```sh
 * $ pulumi import aws:mskconnect/customPlugin:CustomPlugin example 'arn:aws:kafkaconnect:eu-central-1:123456789012:custom-plugin/debezium-example/abcdefgh-1234-5678-9abc-defghijklmno-4'
 * ```
 */
public class CustomPlugin internal constructor(
    override val javaResource: com.pulumi.aws.mskconnect.CustomPlugin,
) : KotlinCustomResource(javaResource, CustomPluginMapper) {
    /**
     * the Amazon Resource Name (ARN) of the custom plugin.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The type of the plugin file. Allowed values are `ZIP` and `JAR`.
     */
    public val contentType: Output<String>
        get() = javaResource.contentType().applyValue({ args0 -> args0 })

    /**
     * A summary description of the custom plugin.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * an ID of the latest successfully created revision of the custom plugin.
     */
    public val latestRevision: Output<Int>
        get() = javaResource.latestRevision().applyValue({ args0 -> args0 })

    /**
     * Information about the location of a custom plugin. See `location` Block for details.
     */
    public val location: Output<CustomPluginLocation>
        get() = javaResource.location().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The name of the custom plugin..
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * the state of the custom plugin.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following arguments are optional:
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object CustomPluginMapper : ResourceMapper<CustomPlugin> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.mskconnect.CustomPlugin::class == javaResource::class

    override fun map(javaResource: Resource): CustomPlugin = CustomPlugin(
        javaResource as
            com.pulumi.aws.mskconnect.CustomPlugin,
    )
}

/**
 * @see [CustomPlugin].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomPlugin].
 */
public suspend fun customPlugin(
    name: String,
    block: suspend CustomPluginResourceBuilder.() -> Unit,
): CustomPlugin {
    val builder = CustomPluginResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomPlugin].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customPlugin(name: String): CustomPlugin {
    val builder = CustomPluginResourceBuilder()
    builder.name(name)
    return builder.build()
}
