@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin

import com.pulumi.aws.mskconnect.CustomPluginArgs.builder
import com.pulumi.aws.mskconnect.kotlin.inputs.CustomPluginLocationArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.CustomPluginLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon MSK Connect Custom Plugin Resource.
 * ## Example Usage
 * ### Basic configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {bucket: "example"});
 * const exampleBucketObjectv2 = new aws.s3.BucketObjectv2("example", {
 *     bucket: example.id,
 *     key: "debezium.zip",
 *     source: new pulumi.asset.FileAsset("debezium.zip"),
 * });
 * const exampleCustomPlugin = new aws.mskconnect.CustomPlugin("example", {
 *     name: "debezium-example",
 *     contentType: "ZIP",
 *     location: {
 *         s3: {
 *             bucketArn: example.arn,
 *             fileKey: exampleBucketObjectv2.key,
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example", bucket="example")
 * example_bucket_objectv2 = aws.s3.BucketObjectv2("example",
 *     bucket=example.id,
 *     key="debezium.zip",
 *     source=pulumi.FileAsset("debezium.zip"))
 * example_custom_plugin = aws.mskconnect.CustomPlugin("example",
 *     name="debezium-example",
 *     content_type="ZIP",
 *     location={
 *         "s3": {
 *             "bucket_arn": example.arn,
 *             "file_key": example_bucket_objectv2.key,
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var exampleBucketObjectv2 = new Aws.S3.BucketObjectv2("example", new()
 *     {
 *         Bucket = example.Id,
 *         Key = "debezium.zip",
 *         Source = new FileAsset("debezium.zip"),
 *     });
 *     var exampleCustomPlugin = new Aws.MskConnect.CustomPlugin("example", new()
 *     {
 *         Name = "debezium-example",
 *         ContentType = "ZIP",
 *         Location = new Aws.MskConnect.Inputs.CustomPluginLocationArgs
 *         {
 *             S3 = new Aws.MskConnect.Inputs.CustomPluginLocationS3Args
 *             {
 *                 BucketArn = example.Arn,
 *                 FileKey = exampleBucketObjectv2.Key,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mskconnect"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleBucketObjectv2, err := s3.NewBucketObjectv2(ctx, "example", &s3.BucketObjectv2Args{
 * 			Bucket: example.ID(),
 * 			Key:    pulumi.String("debezium.zip"),
 * 			Source: pulumi.NewFileAsset("debezium.zip"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = mskconnect.NewCustomPlugin(ctx, "example", &mskconnect.CustomPluginArgs{
 * 			Name:        pulumi.String("debezium-example"),
 * 			ContentType: pulumi.String("ZIP"),
 * 			Location: &mskconnect.CustomPluginLocationArgs{
 * 				S3: &mskconnect.CustomPluginLocationS3Args{
 * 					BucketArn: example.Arn,
 * 					FileKey:   exampleBucketObjectv2.Key,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.mskconnect.CustomPlugin;
 * import com.pulumi.aws.mskconnect.CustomPluginArgs;
 * import com.pulumi.aws.mskconnect.inputs.CustomPluginLocationArgs;
 * import com.pulumi.aws.mskconnect.inputs.CustomPluginLocationS3Args;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var exampleBucketObjectv2 = new BucketObjectv2("exampleBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(example.id())
 *             .key("debezium.zip")
 *             .source(new FileAsset("debezium.zip"))
 *             .build());
 *         var exampleCustomPlugin = new CustomPlugin("exampleCustomPlugin", CustomPluginArgs.builder()
 *             .name("debezium-example")
 *             .contentType("ZIP")
 *             .location(CustomPluginLocationArgs.builder()
 *                 .s3(CustomPluginLocationS3Args.builder()
 *                     .bucketArn(example.arn())
 *                     .fileKey(exampleBucketObjectv2.key())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example
 *   exampleBucketObjectv2:
 *     type: aws:s3:BucketObjectv2
 *     name: example
 *     properties:
 *       bucket: ${example.id}
 *       key: debezium.zip
 *       source:
 *         fn::FileAsset: debezium.zip
 *   exampleCustomPlugin:
 *     type: aws:mskconnect:CustomPlugin
 *     name: example
 *     properties:
 *       name: debezium-example
 *       contentType: ZIP
 *       location:
 *         s3:
 *           bucketArn: ${example.arn}
 *           fileKey: ${exampleBucketObjectv2.key}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MSK Connect Custom Plugin using the plugin's `arn`. For example:
 * ```sh
 * $ pulumi import aws:mskconnect/customPlugin:CustomPlugin example 'arn:aws:kafkaconnect:eu-central-1:123456789012:custom-plugin/debezium-example/abcdefgh-1234-5678-9abc-defghijklmno-4'
 * ```
 * @property contentType The type of the plugin file. Allowed values are `ZIP` and `JAR`.
 * @property description A summary description of the custom plugin.
 * @property location Information about the location of a custom plugin. See `location` Block for details.
 * @property name The name of the custom plugin..
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * The following arguments are optional:
 */
public data class CustomPluginArgs(
    public val contentType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val location: Output<CustomPluginLocationArgs>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.CustomPluginArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.CustomPluginArgs =
        com.pulumi.aws.mskconnect.CustomPluginArgs.builder()
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CustomPluginArgs].
 */
@PulumiTagMarker
public class CustomPluginArgsBuilder internal constructor() {
    private var contentType: Output<String>? = null

    private var description: Output<String>? = null

    private var location: Output<CustomPluginLocationArgs>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The type of the plugin file. Allowed values are `ZIP` and `JAR`.
     */
    @JvmName("gmkjvfjruepuurvb")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value A summary description of the custom plugin.
     */
    @JvmName("gkurduqhdgwfqgti")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Information about the location of a custom plugin. See `location` Block for details.
     */
    @JvmName("rlxgcrmuglvdirax")
    public suspend fun location(`value`: Output<CustomPluginLocationArgs>) {
        this.location = value
    }

    /**
     * @param value The name of the custom plugin..
     */
    @JvmName("yowckslofgmyjwxg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following arguments are optional:
     */
    @JvmName("mwwcsexllflfxgjf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of the plugin file. Allowed values are `ZIP` and `JAR`.
     */
    @JvmName("opfbcdmxdwlmbfew")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value A summary description of the custom plugin.
     */
    @JvmName("axjfilchbdkhwoaj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Information about the location of a custom plugin. See `location` Block for details.
     */
    @JvmName("cksjwystxtxnxxok")
    public suspend fun location(`value`: CustomPluginLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param argument Information about the location of a custom plugin. See `location` Block for details.
     */
    @JvmName("lpapxswaxtmxwwua")
    public suspend fun location(argument: suspend CustomPluginLocationArgsBuilder.() -> Unit) {
        val toBeMapped = CustomPluginLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.location = mapped
    }

    /**
     * @param value The name of the custom plugin..
     */
    @JvmName("evxlkmrxemnungfl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following arguments are optional:
     */
    @JvmName("bygweliwomwyxngk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following arguments are optional:
     */
    @JvmName("ybigrjqnywpfbvys")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CustomPluginArgs = CustomPluginArgs(
        contentType = contentType,
        description = description,
        location = location,
        name = name,
        tags = tags,
    )
}
