@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin

import com.pulumi.aws.mskconnect.MskconnectFunctions.getConnectorPlain
import com.pulumi.aws.mskconnect.MskconnectFunctions.getCustomPluginPlain
import com.pulumi.aws.mskconnect.MskconnectFunctions.getWorkerConfigurationPlain
import com.pulumi.aws.mskconnect.kotlin.inputs.GetConnectorPlainArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.GetConnectorPlainArgsBuilder
import com.pulumi.aws.mskconnect.kotlin.inputs.GetCustomPluginPlainArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.GetCustomPluginPlainArgsBuilder
import com.pulumi.aws.mskconnect.kotlin.inputs.GetWorkerConfigurationPlainArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.GetWorkerConfigurationPlainArgsBuilder
import com.pulumi.aws.mskconnect.kotlin.outputs.GetConnectorResult
import com.pulumi.aws.mskconnect.kotlin.outputs.GetCustomPluginResult
import com.pulumi.aws.mskconnect.kotlin.outputs.GetWorkerConfigurationResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.mskconnect.kotlin.outputs.GetConnectorResult.Companion.toKotlin as getConnectorResultToKotlin
import com.pulumi.aws.mskconnect.kotlin.outputs.GetCustomPluginResult.Companion.toKotlin as getCustomPluginResultToKotlin
import com.pulumi.aws.mskconnect.kotlin.outputs.GetWorkerConfigurationResult.Companion.toKotlin as getWorkerConfigurationResultToKotlin

public object MskconnectFunctions {
    /**
     * Get information on an Amazon MSK Connect Connector.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.mskconnect.getConnector({
     *     name: "example-mskconnector",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.mskconnect.get_connector(name="example-mskconnector")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.MskConnect.GetConnector.Invoke(new()
     *     {
     *         Name = "example-mskconnector",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mskconnect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := mskconnect.LookupConnector(ctx, &mskconnect.LookupConnectorArgs{
     * 			Name: "example-mskconnector",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.mskconnect.MskconnectFunctions;
     * import com.pulumi.aws.mskconnect.inputs.GetConnectorArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MskconnectFunctions.getConnector(GetConnectorArgs.builder()
     *             .name("example-mskconnector")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:mskconnect:getConnector
     *       Arguments:
     *         name: example-mskconnector
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getConnector.
     * @return A collection of values returned by getConnector.
     */
    public suspend fun getConnector(argument: GetConnectorPlainArgs): GetConnectorResult =
        getConnectorResultToKotlin(getConnectorPlain(argument.toJava()).await())

    /**
     * @see [getConnector].
     * @param name Name of the connector.
     * @param tags A map of tags assigned to the resource.
     * @return A collection of values returned by getConnector.
     */
    public suspend fun getConnector(name: String, tags: Map<String, String>? = null): GetConnectorResult {
        val argument = GetConnectorPlainArgs(
            name = name,
            tags = tags,
        )
        return getConnectorResultToKotlin(getConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnector].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;mskconnect&#46;kotlin&#46;inputs&#46;GetConnectorPlainArgs].
     * @return A collection of values returned by getConnector.
     */
    public suspend fun getConnector(argument: suspend GetConnectorPlainArgsBuilder.() -> Unit): GetConnectorResult {
        val builder = GetConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectorResultToKotlin(getConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an Amazon MSK Connect custom plugin.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.mskconnect.getCustomPlugin({
     *     name: "example-debezium-1",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.mskconnect.get_custom_plugin(name="example-debezium-1")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.MskConnect.GetCustomPlugin.Invoke(new()
     *     {
     *         Name = "example-debezium-1",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mskconnect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := mskconnect.LookupCustomPlugin(ctx, &mskconnect.LookupCustomPluginArgs{
     * 			Name: "example-debezium-1",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.mskconnect.MskconnectFunctions;
     * import com.pulumi.aws.mskconnect.inputs.GetCustomPluginArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MskconnectFunctions.getCustomPlugin(GetCustomPluginArgs.builder()
     *             .name("example-debezium-1")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:mskconnect:getCustomPlugin
     *       Arguments:
     *         name: example-debezium-1
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCustomPlugin.
     * @return A collection of values returned by getCustomPlugin.
     */
    public suspend fun getCustomPlugin(argument: GetCustomPluginPlainArgs): GetCustomPluginResult =
        getCustomPluginResultToKotlin(getCustomPluginPlain(argument.toJava()).await())

    /**
     * @see [getCustomPlugin].
     * @param name Name of the custom plugin.
     * @param tags A map of tags assigned to the resource.
     * @return A collection of values returned by getCustomPlugin.
     */
    public suspend fun getCustomPlugin(name: String, tags: Map<String, String>? = null): GetCustomPluginResult {
        val argument = GetCustomPluginPlainArgs(
            name = name,
            tags = tags,
        )
        return getCustomPluginResultToKotlin(getCustomPluginPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomPlugin].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;mskconnect&#46;kotlin&#46;inputs&#46;GetCustomPluginPlainArgs].
     * @return A collection of values returned by getCustomPlugin.
     */
    public suspend fun getCustomPlugin(argument: suspend GetCustomPluginPlainArgsBuilder.() -> Unit): GetCustomPluginResult {
        val builder = GetCustomPluginPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomPluginResultToKotlin(getCustomPluginPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an Amazon MSK Connect Worker Configuration.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.mskconnect.getWorkerConfiguration({
     *     name: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.mskconnect.get_worker_configuration(name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.MskConnect.GetWorkerConfiguration.Invoke(new()
     *     {
     *         Name = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mskconnect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := mskconnect.LookupWorkerConfiguration(ctx, &mskconnect.LookupWorkerConfigurationArgs{
     * 			Name: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.mskconnect.MskconnectFunctions;
     * import com.pulumi.aws.mskconnect.inputs.GetWorkerConfigurationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MskconnectFunctions.getWorkerConfiguration(GetWorkerConfigurationArgs.builder()
     *             .name("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:mskconnect:getWorkerConfiguration
     *       Arguments:
     *         name: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getWorkerConfiguration.
     * @return A collection of values returned by getWorkerConfiguration.
     */
    public suspend fun getWorkerConfiguration(argument: GetWorkerConfigurationPlainArgs): GetWorkerConfigurationResult =
        getWorkerConfigurationResultToKotlin(getWorkerConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getWorkerConfiguration].
     * @param name Name of the worker configuration.
     * @param tags A map of tags assigned to the resource.
     * @return A collection of values returned by getWorkerConfiguration.
     */
    public suspend fun getWorkerConfiguration(name: String, tags: Map<String, String>? = null): GetWorkerConfigurationResult {
        val argument = GetWorkerConfigurationPlainArgs(
            name = name,
            tags = tags,
        )
        return getWorkerConfigurationResultToKotlin(getWorkerConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkerConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;mskconnect&#46;kotlin&#46;inputs&#46;GetWorkerConfigurationPlainArgs].
     * @return A collection of values returned by getWorkerConfiguration.
     */
    public suspend fun getWorkerConfiguration(argument: suspend GetWorkerConfigurationPlainArgsBuilder.() -> Unit): GetWorkerConfigurationResult {
        val builder = GetWorkerConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkerConfigurationResultToKotlin(getWorkerConfigurationPlain(builtArgument.toJava()).await())
    }
}
