@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [WorkerConfiguration].
 */
@PulumiTagMarker
public class WorkerConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkerConfigurationArgs = WorkerConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkerConfigurationArgsBuilder.() -> Unit) {
        val builder = WorkerConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkerConfiguration {
        val builtJavaResource = com.pulumi.aws.mskconnect.WorkerConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WorkerConfiguration(builtJavaResource)
    }
}

/**
 * Provides an Amazon MSK Connect Worker Configuration Resource.
 * ## Example Usage
 * ### Basic configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.mskconnect.WorkerConfiguration("example", {
 *     name: "example",
 *     propertiesFileContent: `key.converter=org.apache.kafka.connect.storage.StringConverter
 * value.converter=org.apache.kafka.connect.storage.StringConverter
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.mskconnect.WorkerConfiguration("example",
 *     name="example",
 *     properties_file_content="""key.converter=org.apache.kafka.connect.storage.StringConverter
 * value.converter=org.apache.kafka.connect.storage.StringConverter
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.MskConnect.WorkerConfiguration("example", new()
 *     {
 *         Name = "example",
 *         PropertiesFileContent = @"key.converter=org.apache.kafka.connect.storage.StringConverter
 * value.converter=org.apache.kafka.connect.storage.StringConverter
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mskconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mskconnect.NewWorkerConfiguration(ctx, "example", &mskconnect.WorkerConfigurationArgs{
 * 			Name:                  pulumi.String("example"),
 * 			PropertiesFileContent: pulumi.String("key.converter=org.apache.kafka.connect.storage.StringConverter\nvalue.converter=org.apache.kafka.connect.storage.StringConverter\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mskconnect.WorkerConfiguration;
 * import com.pulumi.aws.mskconnect.WorkerConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WorkerConfiguration("example", WorkerConfigurationArgs.builder()
 *             .name("example")
 *             .propertiesFileContent("""
 * key.converter=org.apache.kafka.connect.storage.StringConverter
 * value.converter=org.apache.kafka.connect.storage.StringConverter
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:mskconnect:WorkerConfiguration
 *     properties:
 *       name: example
 *       propertiesFileContent: |
 *         key.converter=org.apache.kafka.connect.storage.StringConverter
 *         value.converter=org.apache.kafka.connect.storage.StringConverter
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MSK Connect Worker Configuration using the plugin's `arn`. For example:
 * ```sh
 * $ pulumi import aws:mskconnect/workerConfiguration:WorkerConfiguration example 'arn:aws:kafkaconnect:eu-central-1:123456789012:worker-configuration/example/8848493b-7fcc-478c-a646-4a52634e3378-4'
 * ```
 */
public class WorkerConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.mskconnect.WorkerConfiguration,
) : KotlinCustomResource(javaResource, WorkerConfigurationMapper) {
    /**
     * the Amazon Resource Name (ARN) of the worker configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A summary description of the worker configuration.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * an ID of the latest successfully created revision of the worker configuration.
     */
    public val latestRevision: Output<Int>
        get() = javaResource.latestRevision().applyValue({ args0 -> args0 })

    /**
     * The name of the worker configuration.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Contents of connect-distributed.properties file. The value can be either base64 encoded or in raw format.
     * The following arguments are optional:
     */
    public val propertiesFileContent: Output<String>
        get() = javaResource.propertiesFileContent().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object WorkerConfigurationMapper : ResourceMapper<WorkerConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.mskconnect.WorkerConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): WorkerConfiguration = WorkerConfiguration(
        javaResource
            as com.pulumi.aws.mskconnect.WorkerConfiguration,
    )
}

/**
 * @see [WorkerConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkerConfiguration].
 */
public suspend fun workerConfiguration(
    name: String,
    block: suspend WorkerConfigurationResourceBuilder.() -> Unit,
): WorkerConfiguration {
    val builder = WorkerConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkerConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workerConfiguration(name: String): WorkerConfiguration {
    val builder = WorkerConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
