@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin

import com.pulumi.aws.mskconnect.WorkerConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon MSK Connect Worker Configuration Resource.
 * ## Example Usage
 * ### Basic configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.mskconnect.WorkerConfiguration("example", {
 *     name: "example",
 *     propertiesFileContent: `key.converter=org.apache.kafka.connect.storage.StringConverter
 * value.converter=org.apache.kafka.connect.storage.StringConverter
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.mskconnect.WorkerConfiguration("example",
 *     name="example",
 *     properties_file_content="""key.converter=org.apache.kafka.connect.storage.StringConverter
 * value.converter=org.apache.kafka.connect.storage.StringConverter
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.MskConnect.WorkerConfiguration("example", new()
 *     {
 *         Name = "example",
 *         PropertiesFileContent = @"key.converter=org.apache.kafka.connect.storage.StringConverter
 * value.converter=org.apache.kafka.connect.storage.StringConverter
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mskconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mskconnect.NewWorkerConfiguration(ctx, "example", &mskconnect.WorkerConfigurationArgs{
 * 			Name:                  pulumi.String("example"),
 * 			PropertiesFileContent: pulumi.String("key.converter=org.apache.kafka.connect.storage.StringConverter\nvalue.converter=org.apache.kafka.connect.storage.StringConverter\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mskconnect.WorkerConfiguration;
 * import com.pulumi.aws.mskconnect.WorkerConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WorkerConfiguration("example", WorkerConfigurationArgs.builder()
 *             .name("example")
 *             .propertiesFileContent("""
 * key.converter=org.apache.kafka.connect.storage.StringConverter
 * value.converter=org.apache.kafka.connect.storage.StringConverter
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:mskconnect:WorkerConfiguration
 *     properties:
 *       name: example
 *       propertiesFileContent: |
 *         key.converter=org.apache.kafka.connect.storage.StringConverter
 *         value.converter=org.apache.kafka.connect.storage.StringConverter
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MSK Connect Worker Configuration using the plugin's `arn`. For example:
 * ```sh
 * $ pulumi import aws:mskconnect/workerConfiguration:WorkerConfiguration example 'arn:aws:kafkaconnect:eu-central-1:123456789012:worker-configuration/example/8848493b-7fcc-478c-a646-4a52634e3378-4'
 * ```
 * @property description A summary description of the worker configuration.
 * @property name The name of the worker configuration.
 * @property propertiesFileContent Contents of connect-distributed.properties file. The value can be either base64 encoded or in raw format.
 * The following arguments are optional:
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class WorkerConfigurationArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val propertiesFileContent: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.WorkerConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.WorkerConfigurationArgs =
        com.pulumi.aws.mskconnect.WorkerConfigurationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .propertiesFileContent(propertiesFileContent?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [WorkerConfigurationArgs].
 */
@PulumiTagMarker
public class WorkerConfigurationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var propertiesFileContent: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A summary description of the worker configuration.
     */
    @JvmName("urgpeoqpqvuqpdia")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the worker configuration.
     */
    @JvmName("wxjhsduhmjraweln")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Contents of connect-distributed.properties file. The value can be either base64 encoded or in raw format.
     * The following arguments are optional:
     */
    @JvmName("oihtyqslbcebekmh")
    public suspend fun propertiesFileContent(`value`: Output<String>) {
        this.propertiesFileContent = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bsvegyhuybsoewca")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A summary description of the worker configuration.
     */
    @JvmName("xuhmmpxpcgcdjmdg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the worker configuration.
     */
    @JvmName("givvsgynfowllusu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Contents of connect-distributed.properties file. The value can be either base64 encoded or in raw format.
     * The following arguments are optional:
     */
    @JvmName("lxjkdevuyfroxbxo")
    public suspend fun propertiesFileContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertiesFileContent = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("seeyotojmnmyniad")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("snfirtbqoxtxxuiw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): WorkerConfigurationArgs = WorkerConfigurationArgs(
        description = description,
        name = name,
        propertiesFileContent = propertiesFileContent,
        tags = tags,
    )
}
