@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property maxWorkerCount The maximum number of workers allocated to the connector.
 * @property mcuCount The number of microcontroller units (MCUs) allocated to each connector worker. Valid values: `1`, `2`, `4`, `8`. The default value is `1`.
 * @property minWorkerCount The minimum number of workers allocated to the connector.
 * @property scaleInPolicy The scale-in policy for the connector. See `scale_in_policy` Block for details.
 * @property scaleOutPolicy The scale-out policy for the connector. See `scale_out_policy` Block for details.
 */
public data class ConnectorCapacityAutoscalingArgs(
    public val maxWorkerCount: Output<Int>,
    public val mcuCount: Output<Int>? = null,
    public val minWorkerCount: Output<Int>,
    public val scaleInPolicy: Output<ConnectorCapacityAutoscalingScaleInPolicyArgs>? = null,
    public val scaleOutPolicy: Output<ConnectorCapacityAutoscalingScaleOutPolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingArgs =
        com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingArgs.builder()
            .maxWorkerCount(maxWorkerCount.applyValue({ args0 -> args0 }))
            .mcuCount(mcuCount?.applyValue({ args0 -> args0 }))
            .minWorkerCount(minWorkerCount.applyValue({ args0 -> args0 }))
            .scaleInPolicy(scaleInPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scaleOutPolicy(
                scaleOutPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectorCapacityAutoscalingArgs].
 */
@PulumiTagMarker
public class ConnectorCapacityAutoscalingArgsBuilder internal constructor() {
    private var maxWorkerCount: Output<Int>? = null

    private var mcuCount: Output<Int>? = null

    private var minWorkerCount: Output<Int>? = null

    private var scaleInPolicy: Output<ConnectorCapacityAutoscalingScaleInPolicyArgs>? = null

    private var scaleOutPolicy: Output<ConnectorCapacityAutoscalingScaleOutPolicyArgs>? = null

    /**
     * @param value The maximum number of workers allocated to the connector.
     */
    @JvmName("pbpupkyibgywlxel")
    public suspend fun maxWorkerCount(`value`: Output<Int>) {
        this.maxWorkerCount = value
    }

    /**
     * @param value The number of microcontroller units (MCUs) allocated to each connector worker. Valid values: `1`, `2`, `4`, `8`. The default value is `1`.
     */
    @JvmName("rueiftmmacykquem")
    public suspend fun mcuCount(`value`: Output<Int>) {
        this.mcuCount = value
    }

    /**
     * @param value The minimum number of workers allocated to the connector.
     */
    @JvmName("sgvaxoxodewyagsn")
    public suspend fun minWorkerCount(`value`: Output<Int>) {
        this.minWorkerCount = value
    }

    /**
     * @param value The scale-in policy for the connector. See `scale_in_policy` Block for details.
     */
    @JvmName("qtaligfbseugaxvg")
    public suspend fun scaleInPolicy(`value`: Output<ConnectorCapacityAutoscalingScaleInPolicyArgs>) {
        this.scaleInPolicy = value
    }

    /**
     * @param value The scale-out policy for the connector. See `scale_out_policy` Block for details.
     */
    @JvmName("qdimfmemqrtwmtkh")
    public suspend fun scaleOutPolicy(`value`: Output<ConnectorCapacityAutoscalingScaleOutPolicyArgs>) {
        this.scaleOutPolicy = value
    }

    /**
     * @param value The maximum number of workers allocated to the connector.
     */
    @JvmName("rxjoodiieqiesugf")
    public suspend fun maxWorkerCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxWorkerCount = mapped
    }

    /**
     * @param value The number of microcontroller units (MCUs) allocated to each connector worker. Valid values: `1`, `2`, `4`, `8`. The default value is `1`.
     */
    @JvmName("bhlagjxpaxyhwuht")
    public suspend fun mcuCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mcuCount = mapped
    }

    /**
     * @param value The minimum number of workers allocated to the connector.
     */
    @JvmName("nvnvdigqcqpxeopy")
    public suspend fun minWorkerCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minWorkerCount = mapped
    }

    /**
     * @param value The scale-in policy for the connector. See `scale_in_policy` Block for details.
     */
    @JvmName("oxktakmomihgadat")
    public suspend fun scaleInPolicy(`value`: ConnectorCapacityAutoscalingScaleInPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleInPolicy = mapped
    }

    /**
     * @param argument The scale-in policy for the connector. See `scale_in_policy` Block for details.
     */
    @JvmName("jsinjvclcepaeave")
    public suspend fun scaleInPolicy(argument: suspend ConnectorCapacityAutoscalingScaleInPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorCapacityAutoscalingScaleInPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.scaleInPolicy = mapped
    }

    /**
     * @param value The scale-out policy for the connector. See `scale_out_policy` Block for details.
     */
    @JvmName("xplynospwatygnng")
    public suspend fun scaleOutPolicy(`value`: ConnectorCapacityAutoscalingScaleOutPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleOutPolicy = mapped
    }

    /**
     * @param argument The scale-out policy for the connector. See `scale_out_policy` Block for details.
     */
    @JvmName("fdowtyyulriitofu")
    public suspend fun scaleOutPolicy(argument: suspend ConnectorCapacityAutoscalingScaleOutPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorCapacityAutoscalingScaleOutPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.scaleOutPolicy = mapped
    }

    internal fun build(): ConnectorCapacityAutoscalingArgs = ConnectorCapacityAutoscalingArgs(
        maxWorkerCount = maxWorkerCount ?: throw PulumiNullFieldException("maxWorkerCount"),
        mcuCount = mcuCount,
        minWorkerCount = minWorkerCount ?: throw PulumiNullFieldException("minWorkerCount"),
        scaleInPolicy = scaleInPolicy,
        scaleOutPolicy = scaleOutPolicy,
    )
}
