@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingScaleInPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cpuUtilizationPercentage Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.
 */
public data class ConnectorCapacityAutoscalingScaleInPolicyArgs(
    public val cpuUtilizationPercentage: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingScaleInPolicyArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingScaleInPolicyArgs =
        com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingScaleInPolicyArgs.builder()
            .cpuUtilizationPercentage(cpuUtilizationPercentage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorCapacityAutoscalingScaleInPolicyArgs].
 */
@PulumiTagMarker
public class ConnectorCapacityAutoscalingScaleInPolicyArgsBuilder internal constructor() {
    private var cpuUtilizationPercentage: Output<Int>? = null

    /**
     * @param value Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.
     */
    @JvmName("hquttrtwmmeebkgk")
    public suspend fun cpuUtilizationPercentage(`value`: Output<Int>) {
        this.cpuUtilizationPercentage = value
    }

    /**
     * @param value Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.
     */
    @JvmName("iyfndcpdykeleswl")
    public suspend fun cpuUtilizationPercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuUtilizationPercentage = mapped
    }

    internal fun build(): ConnectorCapacityAutoscalingScaleInPolicyArgs =
        ConnectorCapacityAutoscalingScaleInPolicyArgs(
            cpuUtilizationPercentage = cpuUtilizationPercentage,
        )
}
