@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityProvisionedCapacityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mcuCount The number of microcontroller units (MCUs) allocated to each connector worker. Valid values: `1`, `2`, `4`, `8`. The default value is `1`.
 * @property workerCount The number of workers that are allocated to the connector.
 */
public data class ConnectorCapacityProvisionedCapacityArgs(
    public val mcuCount: Output<Int>? = null,
    public val workerCount: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.ConnectorCapacityProvisionedCapacityArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.ConnectorCapacityProvisionedCapacityArgs =
        com.pulumi.aws.mskconnect.inputs.ConnectorCapacityProvisionedCapacityArgs.builder()
            .mcuCount(mcuCount?.applyValue({ args0 -> args0 }))
            .workerCount(workerCount.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorCapacityProvisionedCapacityArgs].
 */
@PulumiTagMarker
public class ConnectorCapacityProvisionedCapacityArgsBuilder internal constructor() {
    private var mcuCount: Output<Int>? = null

    private var workerCount: Output<Int>? = null

    /**
     * @param value The number of microcontroller units (MCUs) allocated to each connector worker. Valid values: `1`, `2`, `4`, `8`. The default value is `1`.
     */
    @JvmName("mbhsnxdyqygoplms")
    public suspend fun mcuCount(`value`: Output<Int>) {
        this.mcuCount = value
    }

    /**
     * @param value The number of workers that are allocated to the connector.
     */
    @JvmName("lesotfksmlhmuhrl")
    public suspend fun workerCount(`value`: Output<Int>) {
        this.workerCount = value
    }

    /**
     * @param value The number of microcontroller units (MCUs) allocated to each connector worker. Valid values: `1`, `2`, `4`, `8`. The default value is `1`.
     */
    @JvmName("falwjfnqgvlgmwiq")
    public suspend fun mcuCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mcuCount = mapped
    }

    /**
     * @param value The number of workers that are allocated to the connector.
     */
    @JvmName("nldwdpnldnachmfj")
    public suspend fun workerCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workerCount = mapped
    }

    internal fun build(): ConnectorCapacityProvisionedCapacityArgs =
        ConnectorCapacityProvisionedCapacityArgs(
            mcuCount = mcuCount,
            workerCount = workerCount ?: throw PulumiNullFieldException("workerCount"),
        )
}
