@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property apacheKafkaCluster The Apache Kafka cluster to which the connector is connected. See `apache_kafka_cluster` Block for details.
 */
public data class ConnectorKafkaClusterArgs(
    public val apacheKafkaCluster: Output<ConnectorKafkaClusterApacheKafkaClusterArgs>,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterArgs =
        com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterArgs.builder()
            .apacheKafkaCluster(
                apacheKafkaCluster.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectorKafkaClusterArgs].
 */
@PulumiTagMarker
public class ConnectorKafkaClusterArgsBuilder internal constructor() {
    private var apacheKafkaCluster: Output<ConnectorKafkaClusterApacheKafkaClusterArgs>? = null

    /**
     * @param value The Apache Kafka cluster to which the connector is connected. See `apache_kafka_cluster` Block for details.
     */
    @JvmName("gjyrcodrfwvaflef")
    public suspend fun apacheKafkaCluster(`value`: Output<ConnectorKafkaClusterApacheKafkaClusterArgs>) {
        this.apacheKafkaCluster = value
    }

    /**
     * @param value The Apache Kafka cluster to which the connector is connected. See `apache_kafka_cluster` Block for details.
     */
    @JvmName("qbxehwabnfntxruc")
    public suspend fun apacheKafkaCluster(`value`: ConnectorKafkaClusterApacheKafkaClusterArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apacheKafkaCluster = mapped
    }

    /**
     * @param argument The Apache Kafka cluster to which the connector is connected. See `apache_kafka_cluster` Block for details.
     */
    @JvmName("ymycfywwonkyurkd")
    public suspend fun apacheKafkaCluster(argument: suspend ConnectorKafkaClusterApacheKafkaClusterArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorKafkaClusterApacheKafkaClusterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.apacheKafkaCluster = mapped
    }

    internal fun build(): ConnectorKafkaClusterArgs = ConnectorKafkaClusterArgs(
        apacheKafkaCluster = apacheKafkaCluster ?: throw PulumiNullFieldException("apacheKafkaCluster"),
    )
}
