@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterClientAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authenticationType The type of client authentication used to connect to the Apache Kafka cluster. Valid values: `IAM`, `NONE`. A value of `NONE` means that no client authentication is used. The default value is `NONE`.
 */
public data class ConnectorKafkaClusterClientAuthenticationArgs(
    public val authenticationType: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterClientAuthenticationArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterClientAuthenticationArgs =
        com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterClientAuthenticationArgs.builder()
            .authenticationType(authenticationType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorKafkaClusterClientAuthenticationArgs].
 */
@PulumiTagMarker
public class ConnectorKafkaClusterClientAuthenticationArgsBuilder internal constructor() {
    private var authenticationType: Output<String>? = null

    /**
     * @param value The type of client authentication used to connect to the Apache Kafka cluster. Valid values: `IAM`, `NONE`. A value of `NONE` means that no client authentication is used. The default value is `NONE`.
     */
    @JvmName("rdnypkupqgchnrdu")
    public suspend fun authenticationType(`value`: Output<String>) {
        this.authenticationType = value
    }

    /**
     * @param value The type of client authentication used to connect to the Apache Kafka cluster. Valid values: `IAM`, `NONE`. A value of `NONE` means that no client authentication is used. The default value is `NONE`.
     */
    @JvmName("hqppdabflhdcptac")
    public suspend fun authenticationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    internal fun build(): ConnectorKafkaClusterClientAuthenticationArgs =
        ConnectorKafkaClusterClientAuthenticationArgs(
            authenticationType = authenticationType,
        )
}
