@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterEncryptionInTransitArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property encryptionType The type of encryption in transit to the Apache Kafka cluster. Valid values: `PLAINTEXT`, `TLS`. The default values is `PLAINTEXT`.
 */
public data class ConnectorKafkaClusterEncryptionInTransitArgs(
    public val encryptionType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterEncryptionInTransitArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterEncryptionInTransitArgs =
        com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterEncryptionInTransitArgs.builder()
            .encryptionType(encryptionType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorKafkaClusterEncryptionInTransitArgs].
 */
@PulumiTagMarker
public class ConnectorKafkaClusterEncryptionInTransitArgsBuilder internal constructor() {
    private var encryptionType: Output<String>? = null

    /**
     * @param value The type of encryption in transit to the Apache Kafka cluster. Valid values: `PLAINTEXT`, `TLS`. The default values is `PLAINTEXT`.
     */
    @JvmName("weavribkhskxrblg")
    public suspend fun encryptionType(`value`: Output<String>) {
        this.encryptionType = value
    }

    /**
     * @param value The type of encryption in transit to the Apache Kafka cluster. Valid values: `PLAINTEXT`, `TLS`. The default values is `PLAINTEXT`.
     */
    @JvmName("etdumvlbsnrjsvar")
    public suspend fun encryptionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionType = mapped
    }

    internal fun build(): ConnectorKafkaClusterEncryptionInTransitArgs =
        ConnectorKafkaClusterEncryptionInTransitArgs(
            encryptionType = encryptionType,
        )
}
