@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deliveryStream The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.
 * @property enabled Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.
 */
public data class ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs(
    public val deliveryStream: Output<String>? = null,
    public val enabled: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs =
        com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs.builder()
            .deliveryStream(deliveryStream?.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs].
 */
@PulumiTagMarker
public class ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgsBuilder internal constructor() {
    private var deliveryStream: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.
     */
    @JvmName("nfviwxbssvsvmyjx")
    public suspend fun deliveryStream(`value`: Output<String>) {
        this.deliveryStream = value
    }

    /**
     * @param value Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.
     */
    @JvmName("mudjebywxsrojojx")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.
     */
    @JvmName("sxcefsqyirbsjsgf")
    public suspend fun deliveryStream(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryStream = mapped
    }

    /**
     * @param value Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.
     */
    @JvmName("ypfwyymmeanbfkxq")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs =
        ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs(
            deliveryStream = deliveryStream,
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        )
}
