@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.ConnectorPluginArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customPlugin Details about a custom plugin. See `custom_plugin` Block for details.
 */
public data class ConnectorPluginArgs(
    public val customPlugin: Output<ConnectorPluginCustomPluginArgs>,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.ConnectorPluginArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.ConnectorPluginArgs =
        com.pulumi.aws.mskconnect.inputs.ConnectorPluginArgs.builder()
            .customPlugin(customPlugin.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConnectorPluginArgs].
 */
@PulumiTagMarker
public class ConnectorPluginArgsBuilder internal constructor() {
    private var customPlugin: Output<ConnectorPluginCustomPluginArgs>? = null

    /**
     * @param value Details about a custom plugin. See `custom_plugin` Block for details.
     */
    @JvmName("tuogfmjqlxnnvxnc")
    public suspend fun customPlugin(`value`: Output<ConnectorPluginCustomPluginArgs>) {
        this.customPlugin = value
    }

    /**
     * @param value Details about a custom plugin. See `custom_plugin` Block for details.
     */
    @JvmName("rsiymohsloqswmnq")
    public suspend fun customPlugin(`value`: ConnectorPluginCustomPluginArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customPlugin = mapped
    }

    /**
     * @param argument Details about a custom plugin. See `custom_plugin` Block for details.
     */
    @JvmName("yveeyuchtvjhdoul")
    public suspend fun customPlugin(argument: suspend ConnectorPluginCustomPluginArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorPluginCustomPluginArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customPlugin = mapped
    }

    internal fun build(): ConnectorPluginArgs = ConnectorPluginArgs(
        customPlugin = customPlugin ?: throw PulumiNullFieldException("customPlugin"),
    )
}
