@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.ConnectorPluginCustomPluginArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the custom plugin.
 * @property revision The revision of the custom plugin.
 */
public data class ConnectorPluginCustomPluginArgs(
    public val arn: Output<String>,
    public val revision: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.ConnectorPluginCustomPluginArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.ConnectorPluginCustomPluginArgs =
        com.pulumi.aws.mskconnect.inputs.ConnectorPluginCustomPluginArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .revision(revision.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorPluginCustomPluginArgs].
 */
@PulumiTagMarker
public class ConnectorPluginCustomPluginArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var revision: Output<Int>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the custom plugin.
     */
    @JvmName("tcyycalsqquupwad")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The revision of the custom plugin.
     */
    @JvmName("wiueqiamcbctpyen")
    public suspend fun revision(`value`: Output<Int>) {
        this.revision = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the custom plugin.
     */
    @JvmName("snrijsnblapbwnpm")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value The revision of the custom plugin.
     */
    @JvmName("fxlecqdolkxhudfg")
    public suspend fun revision(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.revision = mapped
    }

    internal fun build(): ConnectorPluginCustomPluginArgs = ConnectorPluginCustomPluginArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        revision = revision ?: throw PulumiNullFieldException("revision"),
    )
}
