@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.CustomPluginLocationS3Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketArn The Amazon Resource Name (ARN) of an S3 bucket.
 * @property fileKey The file key for an object in an S3 bucket.
 * @property objectVersion The version of an object in an S3 bucket.
 */
public data class CustomPluginLocationS3Args(
    public val bucketArn: Output<String>,
    public val fileKey: Output<String>,
    public val objectVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.CustomPluginLocationS3Args> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.CustomPluginLocationS3Args =
        com.pulumi.aws.mskconnect.inputs.CustomPluginLocationS3Args.builder()
            .bucketArn(bucketArn.applyValue({ args0 -> args0 }))
            .fileKey(fileKey.applyValue({ args0 -> args0 }))
            .objectVersion(objectVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomPluginLocationS3Args].
 */
@PulumiTagMarker
public class CustomPluginLocationS3ArgsBuilder internal constructor() {
    private var bucketArn: Output<String>? = null

    private var fileKey: Output<String>? = null

    private var objectVersion: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of an S3 bucket.
     */
    @JvmName("twwwwqlvtodkjpfj")
    public suspend fun bucketArn(`value`: Output<String>) {
        this.bucketArn = value
    }

    /**
     * @param value The file key for an object in an S3 bucket.
     */
    @JvmName("svwwwluhcuavjwsr")
    public suspend fun fileKey(`value`: Output<String>) {
        this.fileKey = value
    }

    /**
     * @param value The version of an object in an S3 bucket.
     */
    @JvmName("joahfxkfyukglodf")
    public suspend fun objectVersion(`value`: Output<String>) {
        this.objectVersion = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of an S3 bucket.
     */
    @JvmName("cmyyqocjtnjgffor")
    public suspend fun bucketArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketArn = mapped
    }

    /**
     * @param value The file key for an object in an S3 bucket.
     */
    @JvmName("erxwlxjffsigretu")
    public suspend fun fileKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileKey = mapped
    }

    /**
     * @param value The version of an object in an S3 bucket.
     */
    @JvmName("xnlhjsvcaowjpjiw")
    public suspend fun objectVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectVersion = mapped
    }

    internal fun build(): CustomPluginLocationS3Args = CustomPluginLocationS3Args(
        bucketArn = bucketArn ?: throw PulumiNullFieldException("bucketArn"),
        fileKey = fileKey ?: throw PulumiNullFieldException("fileKey"),
        objectVersion = objectVersion,
    )
}
