@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.GetWorkerConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getWorkerConfiguration.
 * @property name Name of the worker configuration.
 * @property tags A map of tags assigned to the resource.
 */
public data class GetWorkerConfigurationPlainArgs(
    public val name: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.GetWorkerConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.GetWorkerConfigurationPlainArgs =
        com.pulumi.aws.mskconnect.inputs.GetWorkerConfigurationPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetWorkerConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetWorkerConfigurationPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the worker configuration.
     */
    @JvmName("wimhdjswodsoqlbp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value A map of tags assigned to the resource.
     */
    @JvmName("shkptwkcnnffjsvn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the resource.
     */
    @JvmName("jndbldflmumasnoy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetWorkerConfigurationPlainArgs = GetWorkerConfigurationPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
    )
}
