@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property autoscaling Information about the auto scaling parameters for the connector. See `autoscaling` Block for details.
 * @property provisionedCapacity Details about a fixed capacity allocated to a connector. See `provisioned_capacity` Block for details.
 */
public data class ConnectorCapacity(
    public val autoscaling: ConnectorCapacityAutoscaling? = null,
    public val provisionedCapacity: ConnectorCapacityProvisionedCapacity? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mskconnect.outputs.ConnectorCapacity): ConnectorCapacity = ConnectorCapacity(
            autoscaling = javaType.autoscaling().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorCapacityAutoscaling.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisionedCapacity = javaType.provisionedCapacity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorCapacityProvisionedCapacity.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
