@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maxWorkerCount The maximum number of workers allocated to the connector.
 * @property mcuCount The number of microcontroller units (MCUs) allocated to each connector worker. Valid values: `1`, `2`, `4`, `8`. The default value is `1`.
 * @property minWorkerCount The minimum number of workers allocated to the connector.
 * @property scaleInPolicy The scale-in policy for the connector. See `scale_in_policy` Block for details.
 * @property scaleOutPolicy The scale-out policy for the connector. See `scale_out_policy` Block for details.
 */
public data class ConnectorCapacityAutoscaling(
    public val maxWorkerCount: Int,
    public val mcuCount: Int? = null,
    public val minWorkerCount: Int,
    public val scaleInPolicy: ConnectorCapacityAutoscalingScaleInPolicy? = null,
    public val scaleOutPolicy: ConnectorCapacityAutoscalingScaleOutPolicy? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mskconnect.outputs.ConnectorCapacityAutoscaling): ConnectorCapacityAutoscaling = ConnectorCapacityAutoscaling(
            maxWorkerCount = javaType.maxWorkerCount(),
            mcuCount = javaType.mcuCount().map({ args0 -> args0 }).orElse(null),
            minWorkerCount = javaType.minWorkerCount(),
            scaleInPolicy = javaType.scaleInPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorCapacityAutoscalingScaleInPolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scaleOutPolicy = javaType.scaleOutPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorCapacityAutoscalingScaleOutPolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
