@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property mcuCount The number of microcontroller units (MCUs) allocated to each connector worker. Valid values: `1`, `2`, `4`, `8`. The default value is `1`.
 * @property workerCount The number of workers that are allocated to the connector.
 */
public data class ConnectorCapacityProvisionedCapacity(
    public val mcuCount: Int? = null,
    public val workerCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mskconnect.outputs.ConnectorCapacityProvisionedCapacity): ConnectorCapacityProvisionedCapacity = ConnectorCapacityProvisionedCapacity(
            mcuCount = javaType.mcuCount().map({ args0 -> args0 }).orElse(null),
            workerCount = javaType.workerCount(),
        )
    }
}
