@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bootstrapServers The bootstrap servers of the cluster.
 * @property vpc Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster. See `vpc` Block for details.
 */
public data class ConnectorKafkaClusterApacheKafkaCluster(
    public val bootstrapServers: String,
    public val vpc: ConnectorKafkaClusterApacheKafkaClusterVpc,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mskconnect.outputs.ConnectorKafkaClusterApacheKafkaCluster): ConnectorKafkaClusterApacheKafkaCluster = ConnectorKafkaClusterApacheKafkaCluster(
            bootstrapServers = javaType.bootstrapServers(),
            vpc = javaType.vpc().let({ args0 ->
                com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorKafkaClusterApacheKafkaClusterVpc.Companion.toKotlin(args0)
            }),
        )
    }
}
