@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authenticationType The type of client authentication used to connect to the Apache Kafka cluster. Valid values: `IAM`, `NONE`. A value of `NONE` means that no client authentication is used. The default value is `NONE`.
 */
public data class ConnectorKafkaClusterClientAuthentication(
    public val authenticationType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mskconnect.outputs.ConnectorKafkaClusterClientAuthentication): ConnectorKafkaClusterClientAuthentication = ConnectorKafkaClusterClientAuthentication(
            authenticationType = javaType.authenticationType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
