@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Whether log delivery to Amazon CloudWatch Logs is enabled.
 * @property logGroup The name of the CloudWatch log group that is the destination for log delivery.
 */
public data class ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogs(
    public val enabled: Boolean,
    public val logGroup: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mskconnect.outputs.ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogs): ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogs =
            ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogs(
                enabled = javaType.enabled(),
                logGroup = javaType.logGroup().map({ args0 -> args0 }).orElse(null),
            )
    }
}
