@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket The name of the S3 bucket that is the destination for log delivery.
 * @property enabled Specifies whether connector logs get sent to the specified Amazon S3 destination.
 * @property prefix The S3 prefix that is the destination for log delivery.
 */
public data class ConnectorLogDeliveryWorkerLogDeliveryS3(
    public val bucket: String? = null,
    public val enabled: Boolean,
    public val prefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mskconnect.outputs.ConnectorLogDeliveryWorkerLogDeliveryS3): ConnectorLogDeliveryWorkerLogDeliveryS3 = ConnectorLogDeliveryWorkerLogDeliveryS3(
            bucket = javaType.bucket().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled(),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
