@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the worker configuration.
 * @property revision The revision of the worker configuration.
 */
public data class ConnectorWorkerConfiguration(
    public val arn: String,
    public val revision: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mskconnect.outputs.ConnectorWorkerConfiguration): ConnectorWorkerConfiguration = ConnectorWorkerConfiguration(
            arn = javaType.arn(),
            revision = javaType.revision(),
        )
    }
}
