@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getCustomPlugin.
 * @property arn the ARN of the custom plugin.
 * @property description a summary description of the custom plugin.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property latestRevision an ID of the latest successfully created revision of the custom plugin.
 * @property name
 * @property state the state of the custom plugin.
 * @property tags A map of tags assigned to the resource.
 */
public data class GetCustomPluginResult(
    public val arn: String,
    public val description: String,
    public val id: String,
    public val latestRevision: Int,
    public val name: String,
    public val state: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mskconnect.outputs.GetCustomPluginResult): GetCustomPluginResult = GetCustomPluginResult(
            arn = javaType.arn(),
            description = javaType.description(),
            id = javaType.id(),
            latestRevision = javaType.latestRevision(),
            name = javaType.name(),
            state = javaType.state(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
