@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getWorkerConfiguration.
 * @property arn the ARN of the worker configuration.
 * @property description a summary description of the worker configuration.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property latestRevision an ID of the latest successfully created revision of the worker configuration.
 * @property name
 * @property propertiesFileContent contents of connect-distributed.properties file.
 * @property tags A map of tags assigned to the resource.
 */
public data class GetWorkerConfigurationResult(
    public val arn: String,
    public val description: String,
    public val id: String,
    public val latestRevision: Int,
    public val name: String,
    public val propertiesFileContent: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mskconnect.outputs.GetWorkerConfigurationResult): GetWorkerConfigurationResult = GetWorkerConfigurationResult(
            arn = javaType.arn(),
            description = javaType.description(),
            id = javaType.id(),
            latestRevision = javaType.latestRevision(),
            name = javaType.name(),
            propertiesFileContent = javaType.propertiesFileContent(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
