@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mwaa.kotlin

import com.pulumi.aws.mwaa.kotlin.outputs.EnvironmentLastUpdated
import com.pulumi.aws.mwaa.kotlin.outputs.EnvironmentLoggingConfiguration
import com.pulumi.aws.mwaa.kotlin.outputs.EnvironmentNetworkConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.mwaa.kotlin.outputs.EnvironmentLastUpdated.Companion.toKotlin as environmentLastUpdatedToKotlin
import com.pulumi.aws.mwaa.kotlin.outputs.EnvironmentLoggingConfiguration.Companion.toKotlin as environmentLoggingConfigurationToKotlin
import com.pulumi.aws.mwaa.kotlin.outputs.EnvironmentNetworkConfiguration.Companion.toKotlin as environmentNetworkConfigurationToKotlin

/**
 * Builder for [Environment].
 */
@PulumiTagMarker
public class EnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvironmentArgs = EnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvironmentArgsBuilder.() -> Unit) {
        val builder = EnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Environment {
        val builtJavaResource = com.pulumi.aws.mwaa.Environment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Environment(builtJavaResource)
    }
}

/**
 * Creates a MWAA Environment resource.
 * ## Example Usage
 * A MWAA Environment requires an IAM role (`aws.iam.Role`), two subnets in the private zone (`aws.ec2.Subnet`) and a versioned S3 bucket (`aws.s3.BucketV2`).
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.mwaa.Environment("example", {
 *     dagS3Path: "dags/",
 *     executionRoleArn: exampleAwsIamRole.arn,
 *     name: "example",
 *     networkConfiguration: {
 *         securityGroupIds: [exampleAwsSecurityGroup&#46;id],
 *         subnetIds: _private.map(__item => __item.id),
 *     },
 *     sourceBucketArn: exampleAwsS3Bucket.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.mwaa.Environment("example",
 *     dag_s3_path="dags/",
 *     execution_role_arn=example_aws_iam_role["arn"],
 *     name="example",
 *     network_configuration={
 *         "security_group_ids": [example_aws_security_group["id"]],
 *         "subnet_ids": [__item["id"] for __item in private],
 *     },
 *     source_bucket_arn=example_aws_s3_bucket["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Mwaa.Environment("example", new()
 *     {
 *         DagS3Path = "dags/",
 *         ExecutionRoleArn = exampleAwsIamRole.Arn,
 *         Name = "example",
 *         NetworkConfiguration = new Aws.Mwaa.Inputs.EnvironmentNetworkConfigurationArgs
 *         {
 *             SecurityGroupIds = new[]
 *             {
 *                 exampleAwsSecurityGroup.Id,
 *             },
 *             SubnetIds = @private.Select(__item => __item.Id).ToList(),
 *         },
 *         SourceBucketArn = exampleAwsS3Bucket.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mwaa"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := mwaa.NewEnvironment(ctx, "example", &mwaa.EnvironmentArgs{
 * DagS3Path: pulumi.String("dags/"),
 * ExecutionRoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * Name: pulumi.String("example"),
 * NetworkConfiguration: &mwaa.EnvironmentNetworkConfigurationArgs{
 * SecurityGroupIds: pulumi.StringArray{
 * exampleAwsSecurityGroup.Id,
 * },
 * SubnetIds: []pulumi.String(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:6,24-37)),
 * },
 * SourceBucketArn: pulumi.Any(exampleAwsS3Bucket.Arn),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mwaa.Environment;
 * import com.pulumi.aws.mwaa.EnvironmentArgs;
 * import com.pulumi.aws.mwaa.inputs.EnvironmentNetworkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Environment("example", EnvironmentArgs.builder()
 *             .dagS3Path("dags/")
 *             .executionRoleArn(exampleAwsIamRole.arn())
 *             .name("example")
 *             .networkConfiguration(EnvironmentNetworkConfigurationArgs.builder()
 *                 .securityGroupIds(exampleAwsSecurityGroup.id())
 *                 .subnetIds(private_.stream().map(element -> element.id()).collect(toList()))
 *                 .build())
 *             .sourceBucketArn(exampleAwsS3Bucket.arn())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example with Airflow configuration options
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.mwaa.Environment("example", {
 *     airflowConfigurationOptions: {
 *         "core.default_task_retries": "16",
 *         "core.parallelism": "1",
 *     },
 *     dagS3Path: "dags/",
 *     executionRoleArn: exampleAwsIamRole.arn,
 *     name: "example",
 *     networkConfiguration: {
 *         securityGroupIds: [exampleAwsSecurityGroup&#46;id],
 *         subnetIds: _private.map(__item => __item.id),
 *     },
 *     sourceBucketArn: exampleAwsS3Bucket.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.mwaa.Environment("example",
 *     airflow_configuration_options={
 *         "core.default_task_retries": "16",
 *         "core.parallelism": "1",
 *     },
 *     dag_s3_path="dags/",
 *     execution_role_arn=example_aws_iam_role["arn"],
 *     name="example",
 *     network_configuration={
 *         "security_group_ids": [example_aws_security_group["id"]],
 *         "subnet_ids": [__item["id"] for __item in private],
 *     },
 *     source_bucket_arn=example_aws_s3_bucket["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Mwaa.Environment("example", new()
 *     {
 *         AirflowConfigurationOptions =
 *         {
 *             { "core.default_task_retries", "16" },
 *             { "core.parallelism", "1" },
 *         },
 *         DagS3Path = "dags/",
 *         ExecutionRoleArn = exampleAwsIamRole.Arn,
 *         Name = "example",
 *         NetworkConfiguration = new Aws.Mwaa.Inputs.EnvironmentNetworkConfigurationArgs
 *         {
 *             SecurityGroupIds = new[]
 *             {
 *                 exampleAwsSecurityGroup.Id,
 *             },
 *             SubnetIds = @private.Select(__item => __item.Id).ToList(),
 *         },
 *         SourceBucketArn = exampleAwsS3Bucket.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mwaa"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := mwaa.NewEnvironment(ctx, "example", &mwaa.EnvironmentArgs{
 * AirflowConfigurationOptions: pulumi.StringMap{
 * "core.default_task_retries": pulumi.String("16"),
 * "core.parallelism": pulumi.String("1"),
 * },
 * DagS3Path: pulumi.String("dags/"),
 * ExecutionRoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * Name: pulumi.String("example"),
 * NetworkConfiguration: &mwaa.EnvironmentNetworkConfigurationArgs{
 * SecurityGroupIds: pulumi.StringArray{
 * exampleAwsSecurityGroup.Id,
 * },
 * SubnetIds: []pulumi.String(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:10,24-37)),
 * },
 * SourceBucketArn: pulumi.Any(exampleAwsS3Bucket.Arn),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mwaa.Environment;
 * import com.pulumi.aws.mwaa.EnvironmentArgs;
 * import com.pulumi.aws.mwaa.inputs.EnvironmentNetworkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Environment("example", EnvironmentArgs.builder()
 *             .airflowConfigurationOptions(Map.ofEntries(
 *                 Map.entry("core.default_task_retries", 16),
 *                 Map.entry("core.parallelism", 1)
 *             ))
 *             .dagS3Path("dags/")
 *             .executionRoleArn(exampleAwsIamRole.arn())
 *             .name("example")
 *             .networkConfiguration(EnvironmentNetworkConfigurationArgs.builder()
 *                 .securityGroupIds(exampleAwsSecurityGroup.id())
 *                 .subnetIds(private_.stream().map(element -> element.id()).collect(toList()))
 *                 .build())
 *             .sourceBucketArn(exampleAwsS3Bucket.arn())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example with logging configurations
 * Note that Airflow task logs are enabled by default with the `INFO` log level.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.mwaa.Environment("example", {
 *     dagS3Path: "dags/",
 *     executionRoleArn: exampleAwsIamRole.arn,
 *     loggingConfiguration: {
 *         dagProcessingLogs: {
 *             enabled: true,
 *             logLevel: "DEBUG",
 *         },
 *         schedulerLogs: {
 *             enabled: true,
 *             logLevel: "INFO",
 *         },
 *         taskLogs: {
 *             enabled: true,
 *             logLevel: "WARNING",
 *         },
 *         webserverLogs: {
 *             enabled: true,
 *             logLevel: "ERROR",
 *         },
 *         workerLogs: {
 *             enabled: true,
 *             logLevel: "CRITICAL",
 *         },
 *     },
 *     name: "example",
 *     networkConfiguration: {
 *         securityGroupIds: [exampleAwsSecurityGroup&#46;id],
 *         subnetIds: _private.map(__item => __item.id),
 *     },
 *     sourceBucketArn: exampleAwsS3Bucket.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.mwaa.Environment("example",
 *     dag_s3_path="dags/",
 *     execution_role_arn=example_aws_iam_role["arn"],
 *     logging_configuration={
 *         "dag_processing_logs": {
 *             "enabled": True,
 *             "log_level": "DEBUG",
 *         },
 *         "scheduler_logs": {
 *             "enabled": True,
 *             "log_level": "INFO",
 *         },
 *         "task_logs": {
 *             "enabled": True,
 *             "log_level": "WARNING",
 *         },
 *         "webserver_logs": {
 *             "enabled": True,
 *             "log_level": "ERROR",
 *         },
 *         "worker_logs": {
 *             "enabled": True,
 *             "log_level": "CRITICAL",
 *         },
 *     },
 *     name="example",
 *     network_configuration={
 *         "security_group_ids": [example_aws_security_group["id"]],
 *         "subnet_ids": [__item["id"] for __item in private],
 *     },
 *     source_bucket_arn=example_aws_s3_bucket["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Mwaa.Environment("example", new()
 *     {
 *         DagS3Path = "dags/",
 *         ExecutionRoleArn = exampleAwsIamRole.Arn,
 *         LoggingConfiguration = new Aws.Mwaa.Inputs.EnvironmentLoggingConfigurationArgs
 *         {
 *             DagProcessingLogs = new Aws.Mwaa.Inputs.EnvironmentLoggingConfigurationDagProcessingLogsArgs
 *             {
 *                 Enabled = true,
 *                 LogLevel = "DEBUG",
 *             },
 *             SchedulerLogs = new Aws.Mwaa.Inputs.EnvironmentLoggingConfigurationSchedulerLogsArgs
 *             {
 *                 Enabled = true,
 *                 LogLevel = "INFO",
 *             },
 *             TaskLogs = new Aws.Mwaa.Inputs.EnvironmentLoggingConfigurationTaskLogsArgs
 *             {
 *                 Enabled = true,
 *                 LogLevel = "WARNING",
 *             },
 *             WebserverLogs = new Aws.Mwaa.Inputs.EnvironmentLoggingConfigurationWebserverLogsArgs
 *             {
 *                 Enabled = true,
 *                 LogLevel = "ERROR",
 *             },
 *             WorkerLogs = new Aws.Mwaa.Inputs.EnvironmentLoggingConfigurationWorkerLogsArgs
 *             {
 *                 Enabled = true,
 *                 LogLevel = "CRITICAL",
 *             },
 *         },
 *         Name = "example",
 *         NetworkConfiguration = new Aws.Mwaa.Inputs.EnvironmentNetworkConfigurationArgs
 *         {
 *             SecurityGroupIds = new[]
 *             {
 *                 exampleAwsSecurityGroup.Id,
 *             },
 *             SubnetIds = @private.Select(__item => __item.Id).ToList(),
 *         },
 *         SourceBucketArn = exampleAwsS3Bucket.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mwaa"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := mwaa.NewEnvironment(ctx, "example", &mwaa.EnvironmentArgs{
 * DagS3Path: pulumi.String("dags/"),
 * ExecutionRoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * LoggingConfiguration: &mwaa.EnvironmentLoggingConfigurationArgs{
 * DagProcessingLogs: &mwaa.EnvironmentLoggingConfigurationDagProcessingLogsArgs{
 * Enabled: pulumi.Bool(true),
 * LogLevel: pulumi.String("DEBUG"),
 * },
 * SchedulerLogs: &mwaa.EnvironmentLoggingConfigurationSchedulerLogsArgs{
 * Enabled: pulumi.Bool(true),
 * LogLevel: pulumi.String("INFO"),
 * },
 * TaskLogs: &mwaa.EnvironmentLoggingConfigurationTaskLogsArgs{
 * Enabled: pulumi.Bool(true),
 * LogLevel: pulumi.String("WARNING"),
 * },
 * WebserverLogs: &mwaa.EnvironmentLoggingConfigurationWebserverLogsArgs{
 * Enabled: pulumi.Bool(true),
 * LogLevel: pulumi.String("ERROR"),
 * },
 * WorkerLogs: &mwaa.EnvironmentLoggingConfigurationWorkerLogsArgs{
 * Enabled: pulumi.Bool(true),
 * LogLevel: pulumi.String("CRITICAL"),
 * },
 * },
 * Name: pulumi.String("example"),
 * NetworkConfiguration: &mwaa.EnvironmentNetworkConfigurationArgs{
 * SecurityGroupIds: pulumi.StringArray{
 * exampleAwsSecurityGroup.Id,
 * },
 * SubnetIds: []pulumi.String(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:28,24-37)),
 * },
 * SourceBucketArn: pulumi.Any(exampleAwsS3Bucket.Arn),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mwaa.Environment;
 * import com.pulumi.aws.mwaa.EnvironmentArgs;
 * import com.pulumi.aws.mwaa.inputs.EnvironmentLoggingConfigurationArgs;
 * import com.pulumi.aws.mwaa.inputs.EnvironmentLoggingConfigurationDagProcessingLogsArgs;
 * import com.pulumi.aws.mwaa.inputs.EnvironmentLoggingConfigurationSchedulerLogsArgs;
 * import com.pulumi.aws.mwaa.inputs.EnvironmentLoggingConfigurationTaskLogsArgs;
 * import com.pulumi.aws.mwaa.inputs.EnvironmentLoggingConfigurationWebserverLogsArgs;
 * import com.pulumi.aws.mwaa.inputs.EnvironmentLoggingConfigurationWorkerLogsArgs;
 * import com.pulumi.aws.mwaa.inputs.EnvironmentNetworkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Environment("example", EnvironmentArgs.builder()
 *             .dagS3Path("dags/")
 *             .executionRoleArn(exampleAwsIamRole.arn())
 *             .loggingConfiguration(EnvironmentLoggingConfigurationArgs.builder()
 *                 .dagProcessingLogs(EnvironmentLoggingConfigurationDagProcessingLogsArgs.builder()
 *                     .enabled(true)
 *                     .logLevel("DEBUG")
 *                     .build())
 *                 .schedulerLogs(EnvironmentLoggingConfigurationSchedulerLogsArgs.builder()
 *                     .enabled(true)
 *                     .logLevel("INFO")
 *                     .build())
 *                 .taskLogs(EnvironmentLoggingConfigurationTaskLogsArgs.builder()
 *                     .enabled(true)
 *                     .logLevel("WARNING")
 *                     .build())
 *                 .webserverLogs(EnvironmentLoggingConfigurationWebserverLogsArgs.builder()
 *                     .enabled(true)
 *                     .logLevel("ERROR")
 *                     .build())
 *                 .workerLogs(EnvironmentLoggingConfigurationWorkerLogsArgs.builder()
 *                     .enabled(true)
 *                     .logLevel("CRITICAL")
 *                     .build())
 *                 .build())
 *             .name("example")
 *             .networkConfiguration(EnvironmentNetworkConfigurationArgs.builder()
 *                 .securityGroupIds(exampleAwsSecurityGroup.id())
 *                 .subnetIds(private_.stream().map(element -> element.id()).collect(toList()))
 *                 .build())
 *             .sourceBucketArn(exampleAwsS3Bucket.arn())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example with tags
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.mwaa.Environment("example", {
 *     dagS3Path: "dags/",
 *     executionRoleArn: exampleAwsIamRole.arn,
 *     name: "example",
 *     networkConfiguration: {
 *         securityGroupIds: [exampleAwsSecurityGroup&#46;id],
 *         subnetIds: _private.map(__item => __item.id),
 *     },
 *     sourceBucketArn: exampleAwsS3Bucket.arn,
 *     tags: {
 *         Name: "example",
 *         Environment: "production",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.mwaa.Environment("example",
 *     dag_s3_path="dags/",
 *     execution_role_arn=example_aws_iam_role["arn"],
 *     name="example",
 *     network_configuration={
 *         "security_group_ids": [example_aws_security_group["id"]],
 *         "subnet_ids": [__item["id"] for __item in private],
 *     },
 *     source_bucket_arn=example_aws_s3_bucket["arn"],
 *     tags={
 *         "Name": "example",
 *         "Environment": "production",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Mwaa.Environment("example", new()
 *     {
 *         DagS3Path = "dags/",
 *         ExecutionRoleArn = exampleAwsIamRole.Arn,
 *         Name = "example",
 *         NetworkConfiguration = new Aws.Mwaa.Inputs.EnvironmentNetworkConfigurationArgs
 *         {
 *             SecurityGroupIds = new[]
 *             {
 *                 exampleAwsSecurityGroup.Id,
 *             },
 *             SubnetIds = @private.Select(__item => __item.Id).ToList(),
 *         },
 *         SourceBucketArn = exampleAwsS3Bucket.Arn,
 *         Tags =
 *         {
 *             { "Name", "example" },
 *             { "Environment", "production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mwaa"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := mwaa.NewEnvironment(ctx, "example", &mwaa.EnvironmentArgs{
 * DagS3Path: pulumi.String("dags/"),
 * ExecutionRoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * Name: pulumi.String("example"),
 * NetworkConfiguration: &mwaa.EnvironmentNetworkConfigurationArgs{
 * SecurityGroupIds: pulumi.StringArray{
 * exampleAwsSecurityGroup.Id,
 * },
 * SubnetIds: []pulumi.String(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:6,24-37)),
 * },
 * SourceBucketArn: pulumi.Any(exampleAwsS3Bucket.Arn),
 * Tags: pulumi.StringMap{
 * "Name": pulumi.String("example"),
 * "Environment": pulumi.String("production"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mwaa.Environment;
 * import com.pulumi.aws.mwaa.EnvironmentArgs;
 * import com.pulumi.aws.mwaa.inputs.EnvironmentNetworkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Environment("example", EnvironmentArgs.builder()
 *             .dagS3Path("dags/")
 *             .executionRoleArn(exampleAwsIamRole.arn())
 *             .name("example")
 *             .networkConfiguration(EnvironmentNetworkConfigurationArgs.builder()
 *                 .securityGroupIds(exampleAwsSecurityGroup.id())
 *                 .subnetIds(private_.stream().map(element -> element.id()).collect(toList()))
 *                 .build())
 *             .sourceBucketArn(exampleAwsS3Bucket.arn())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "example"),
 *                 Map.entry("Environment", "production")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MWAA Environment using `Name`. For example:
 * ```sh
 * $ pulumi import aws:mwaa/environment:Environment example MyAirflowEnvironment
 * ```
 */
public class Environment internal constructor(
    override val javaResource: com.pulumi.aws.mwaa.Environment,
) : KotlinCustomResource(javaResource, EnvironmentMapper) {
    /**
     * The `airflow_configuration_options` parameter specifies airflow override options. Check the [Official documentation](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html#configuring-env-variables-reference) for all possible configuration options.
     */
    public val airflowConfigurationOptions: Output<Map<String, String>>?
        get() = javaResource.airflowConfigurationOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Airflow version of your environment, will be set by default to the latest version that MWAA supports.
     */
    public val airflowVersion: Output<String>
        get() = javaResource.airflowVersion().applyValue({ args0 -> args0 })

    /**
     * The ARN of the MWAA Environment
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Created At date of the MWAA Environment
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The relative path to the DAG folder on your Amazon S3 storage bucket. For example, dags. For more information, see [Importing DAGs on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import.html).
     */
    public val dagS3Path: Output<String>
        get() = javaResource.dagS3Path().applyValue({ args0 -> args0 })

    /**
     * The VPC endpoint for the environment's Amazon RDS database
     * * `logging_configuration[0]&#46;<LOG_CONFIGURATION_TYPE>[0].cloud_watch_log_group_arn` - Provides the ARN for the CloudWatch group where the logs will be published
     */
    public val databaseVpcEndpointService: Output<String>
        get() = javaResource.databaseVpcEndpointService().applyValue({ args0 -> args0 })

    /**
     * Defines whether the VPC endpoints configured for the environment are created and managed by the customer or by AWS. If set to `SERVICE`, Amazon MWAA will create and manage the required VPC endpoints in your VPC. If set to `CUSTOMER`, you must create, and manage, the VPC endpoints for your VPC. Defaults to `SERVICE` if not set.
     */
    public val endpointManagement: Output<String>
        get() = javaResource.endpointManagement().applyValue({ args0 -> args0 })

    /**
     * Environment class for the cluster. Possible options are `mw1.small`, `mw1.medium`, `mw1.large`. Will be set by default to `mw1.small`. Please check the [AWS Pricing](https://aws.amazon.com/de/managed-workflows-for-apache-airflow/pricing/) for more information about the environment classes.
     */
    public val environmentClass: Output<String>
        get() = javaResource.environmentClass().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the task execution role that the Amazon MWAA and its environment can assume. Check the [official AWS documentation](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html) for the detailed role specification.
     */
    public val executionRoleArn: Output<String>
        get() = javaResource.executionRoleArn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of your KMS key that you want to use for encryption. Will be set to the ARN of the managed KMS key `aws/airflow` by default. Please check the [Official Documentation](https://docs.aws.amazon.com/mwaa/latest/userguide/custom-keys-certs.html) for more information.
     */
    public val kmsKey: Output<String>?
        get() = javaResource.kmsKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val lastUpdateds: Output<List<EnvironmentLastUpdated>>
        get() = javaResource.lastUpdateds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    environmentLastUpdatedToKotlin(args0)
                })
            })
        })

    /**
     * The Apache Airflow logs you want to send to Amazon CloudWatch Logs. See `logging_configuration` Block for details.
     */
    public val loggingConfiguration: Output<EnvironmentLoggingConfiguration>
        get() = javaResource.loggingConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                environmentLoggingConfigurationToKotlin(args0)
            })
        })

    /**
     * The maximum number of web servers that you want to run in your environment. Value need to be between `2` and `5`. Will be `2` by default.
     */
    public val maxWebservers: Output<Int>
        get() = javaResource.maxWebservers().applyValue({ args0 -> args0 })

    /**
     * The maximum number of workers that can be automatically scaled up. Value need to be between `1` and `25`. Will be `10` by default.
     */
    public val maxWorkers: Output<Int>
        get() = javaResource.maxWorkers().applyValue({ args0 -> args0 })

    /**
     * The minimum number of web servers that you want to run in your environment. Value need to be between `2` and `5`. Will be `2` by default.
     */
    public val minWebservers: Output<Int>
        get() = javaResource.minWebservers().applyValue({ args0 -> args0 })

    /**
     * The minimum number of workers that you want to run in your environment. Will be `1` by default.
     */
    public val minWorkers: Output<Int>
        get() = javaResource.minWorkers().applyValue({ args0 -> args0 })

    /**
     * The name of the Apache Airflow Environment
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the network configuration for your Apache Airflow Environment. This includes two private subnets as well as security groups for the Airflow environment. Each subnet requires internet connection, otherwise the deployment will fail. See `network_configuration` Block for details.
     */
    public val networkConfiguration: Output<EnvironmentNetworkConfiguration>
        get() = javaResource.networkConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                environmentNetworkConfigurationToKotlin(args0)
            })
        })

    /**
     * The plugins.zip file version you want to use.
     */
    public val pluginsS3ObjectVersion: Output<String>
        get() = javaResource.pluginsS3ObjectVersion().applyValue({ args0 -> args0 })

    /**
     * The relative path to the plugins.zip file on your Amazon S3 storage bucket. For example, plugins.zip. If a relative path is provided in the request, then plugins_s3_object_version is required. For more information, see [Importing DAGs on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import.html).
     */
    public val pluginsS3Path: Output<String>?
        get() = javaResource.pluginsS3Path().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The requirements.txt file version you want to use.
     */
    public val requirementsS3ObjectVersion: Output<String>
        get() = javaResource.requirementsS3ObjectVersion().applyValue({ args0 -> args0 })

    /**
     * The relative path to the requirements.txt file on your Amazon S3 storage bucket. For example, requirements.txt. If a relative path is provided in the request, then requirements_s3_object_version is required. For more information, see [Importing DAGs on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import.html).
     */
    public val requirementsS3Path: Output<String>?
        get() = javaResource.requirementsS3Path().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of schedulers that you want to run in your environment. v2.0.2 and above accepts `2` - `5`, default `2`. v1.10.12 accepts `1`.
     */
    public val schedulers: Output<Int>
        get() = javaResource.schedulers().applyValue({ args0 -> args0 })

    /**
     * The Service Role ARN of the Amazon MWAA Environment
     */
    public val serviceRoleArn: Output<String>
        get() = javaResource.serviceRoleArn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of your Amazon S3 storage bucket. For example, arn:aws:s3:::airflow-mybucketname.
     */
    public val sourceBucketArn: Output<String>
        get() = javaResource.sourceBucketArn().applyValue({ args0 -> args0 })

    /**
     * The version of the startup shell script you want to use. You must specify the version ID that Amazon S3 assigns to the file every time you update the script.
     */
    public val startupScriptS3ObjectVersion: Output<String>
        get() = javaResource.startupScriptS3ObjectVersion().applyValue({ args0 -> args0 })

    /**
     * The relative path to the script hosted in your bucket. The script runs as your environment starts before starting the Apache Airflow process. Use this script to install dependencies, modify configuration options, and set environment variables. See [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html). Supported for environment versions 2.x and later.
     */
    public val startupScriptS3Path: Output<String>?
        get() = javaResource.startupScriptS3Path().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the Amazon MWAA Environment
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Specifies whether the webserver should be accessible over the internet or via your specified VPC. Possible options: `PRIVATE_ONLY` (default) and `PUBLIC_ONLY`.
     */
    public val webserverAccessMode: Output<String>
        get() = javaResource.webserverAccessMode().applyValue({ args0 -> args0 })

    /**
     * The webserver URL of the MWAA Environment
     */
    public val webserverUrl: Output<String>
        get() = javaResource.webserverUrl().applyValue({ args0 -> args0 })

    /**
     * The VPC endpoint for the environment's web server
     */
    public val webserverVpcEndpointService: Output<String>
        get() = javaResource.webserverVpcEndpointService().applyValue({ args0 -> args0 })

    /**
     * Specifies the start date for the weekly maintenance window.
     */
    public val weeklyMaintenanceWindowStart: Output<String>
        get() = javaResource.weeklyMaintenanceWindowStart().applyValue({ args0 -> args0 })
}

public object EnvironmentMapper : ResourceMapper<Environment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.mwaa.Environment::class == javaResource::class

    override fun map(javaResource: Resource): Environment = Environment(
        javaResource as
            com.pulumi.aws.mwaa.Environment,
    )
}

/**
 * @see [Environment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Environment].
 */
public suspend fun environment(name: String, block: suspend EnvironmentResourceBuilder.() -> Unit): Environment {
    val builder = EnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Environment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun environment(name: String): Environment {
    val builder = EnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
