@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mwaa.kotlin.inputs

import com.pulumi.aws.mwaa.inputs.EnvironmentLoggingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property dagProcessingLogs (Optional) Log configuration options for processing DAGs. See Module logging configuration for more information. Disabled by default.
 * @property schedulerLogs Log configuration options for the schedulers. See Module logging configuration for more information. Disabled by default.
 * @property taskLogs Log configuration options for DAG tasks. See Module logging configuration for more information. Enabled by default with `INFO` log level.
 * @property webserverLogs Log configuration options for the webservers. See Module logging configuration for more information. Disabled by default.
 * @property workerLogs Log configuration options for the workers. See Module logging configuration for more information. Disabled by default.
 */
public data class EnvironmentLoggingConfigurationArgs(
    public val dagProcessingLogs: Output<EnvironmentLoggingConfigurationDagProcessingLogsArgs>? =
        null,
    public val schedulerLogs: Output<EnvironmentLoggingConfigurationSchedulerLogsArgs>? = null,
    public val taskLogs: Output<EnvironmentLoggingConfigurationTaskLogsArgs>? = null,
    public val webserverLogs: Output<EnvironmentLoggingConfigurationWebserverLogsArgs>? = null,
    public val workerLogs: Output<EnvironmentLoggingConfigurationWorkerLogsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.mwaa.inputs.EnvironmentLoggingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.mwaa.inputs.EnvironmentLoggingConfigurationArgs =
        com.pulumi.aws.mwaa.inputs.EnvironmentLoggingConfigurationArgs.builder()
            .dagProcessingLogs(dagProcessingLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .schedulerLogs(schedulerLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .taskLogs(taskLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .webserverLogs(webserverLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workerLogs(workerLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EnvironmentLoggingConfigurationArgs].
 */
@PulumiTagMarker
public class EnvironmentLoggingConfigurationArgsBuilder internal constructor() {
    private var dagProcessingLogs: Output<EnvironmentLoggingConfigurationDagProcessingLogsArgs>? =
        null

    private var schedulerLogs: Output<EnvironmentLoggingConfigurationSchedulerLogsArgs>? = null

    private var taskLogs: Output<EnvironmentLoggingConfigurationTaskLogsArgs>? = null

    private var webserverLogs: Output<EnvironmentLoggingConfigurationWebserverLogsArgs>? = null

    private var workerLogs: Output<EnvironmentLoggingConfigurationWorkerLogsArgs>? = null

    /**
     * @param value (Optional) Log configuration options for processing DAGs. See Module logging configuration for more information. Disabled by default.
     */
    @JvmName("mslyjtqpjrekbenk")
    public suspend fun dagProcessingLogs(`value`: Output<EnvironmentLoggingConfigurationDagProcessingLogsArgs>) {
        this.dagProcessingLogs = value
    }

    /**
     * @param value Log configuration options for the schedulers. See Module logging configuration for more information. Disabled by default.
     */
    @JvmName("tvhnxgqtfkdnjpcv")
    public suspend fun schedulerLogs(`value`: Output<EnvironmentLoggingConfigurationSchedulerLogsArgs>) {
        this.schedulerLogs = value
    }

    /**
     * @param value Log configuration options for DAG tasks. See Module logging configuration for more information. Enabled by default with `INFO` log level.
     */
    @JvmName("gobkhcgyjhggnehg")
    public suspend fun taskLogs(`value`: Output<EnvironmentLoggingConfigurationTaskLogsArgs>) {
        this.taskLogs = value
    }

    /**
     * @param value Log configuration options for the webservers. See Module logging configuration for more information. Disabled by default.
     */
    @JvmName("riyjndnpmlnqbkyy")
    public suspend fun webserverLogs(`value`: Output<EnvironmentLoggingConfigurationWebserverLogsArgs>) {
        this.webserverLogs = value
    }

    /**
     * @param value Log configuration options for the workers. See Module logging configuration for more information. Disabled by default.
     */
    @JvmName("upchrjdgpkimfvyh")
    public suspend fun workerLogs(`value`: Output<EnvironmentLoggingConfigurationWorkerLogsArgs>) {
        this.workerLogs = value
    }

    /**
     * @param value (Optional) Log configuration options for processing DAGs. See Module logging configuration for more information. Disabled by default.
     */
    @JvmName("rpsdqdtuoaitcwmh")
    public suspend fun dagProcessingLogs(`value`: EnvironmentLoggingConfigurationDagProcessingLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dagProcessingLogs = mapped
    }

    /**
     * @param argument (Optional) Log configuration options for processing DAGs. See Module logging configuration for more information. Disabled by default.
     */
    @JvmName("gbfmwtfwlbgywypd")
    public suspend fun dagProcessingLogs(argument: suspend EnvironmentLoggingConfigurationDagProcessingLogsArgsBuilder.() -> Unit) {
        val toBeMapped = EnvironmentLoggingConfigurationDagProcessingLogsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dagProcessingLogs = mapped
    }

    /**
     * @param value Log configuration options for the schedulers. See Module logging configuration for more information. Disabled by default.
     */
    @JvmName("mrdiujfwrusmmirk")
    public suspend fun schedulerLogs(`value`: EnvironmentLoggingConfigurationSchedulerLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedulerLogs = mapped
    }

    /**
     * @param argument Log configuration options for the schedulers. See Module logging configuration for more information. Disabled by default.
     */
    @JvmName("dvcadjridawdtonb")
    public suspend fun schedulerLogs(argument: suspend EnvironmentLoggingConfigurationSchedulerLogsArgsBuilder.() -> Unit) {
        val toBeMapped = EnvironmentLoggingConfigurationSchedulerLogsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.schedulerLogs = mapped
    }

    /**
     * @param value Log configuration options for DAG tasks. See Module logging configuration for more information. Enabled by default with `INFO` log level.
     */
    @JvmName("lryijilnpvskurcx")
    public suspend fun taskLogs(`value`: EnvironmentLoggingConfigurationTaskLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskLogs = mapped
    }

    /**
     * @param argument Log configuration options for DAG tasks. See Module logging configuration for more information. Enabled by default with `INFO` log level.
     */
    @JvmName("omfumbarumuhjblo")
    public suspend fun taskLogs(argument: suspend EnvironmentLoggingConfigurationTaskLogsArgsBuilder.() -> Unit) {
        val toBeMapped = EnvironmentLoggingConfigurationTaskLogsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.taskLogs = mapped
    }

    /**
     * @param value Log configuration options for the webservers. See Module logging configuration for more information. Disabled by default.
     */
    @JvmName("vnvvpiaufsrtqsdw")
    public suspend fun webserverLogs(`value`: EnvironmentLoggingConfigurationWebserverLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webserverLogs = mapped
    }

    /**
     * @param argument Log configuration options for the webservers. See Module logging configuration for more information. Disabled by default.
     */
    @JvmName("lgncsutmguxkkqih")
    public suspend fun webserverLogs(argument: suspend EnvironmentLoggingConfigurationWebserverLogsArgsBuilder.() -> Unit) {
        val toBeMapped = EnvironmentLoggingConfigurationWebserverLogsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.webserverLogs = mapped
    }

    /**
     * @param value Log configuration options for the workers. See Module logging configuration for more information. Disabled by default.
     */
    @JvmName("yxxpihbiocnyuwyk")
    public suspend fun workerLogs(`value`: EnvironmentLoggingConfigurationWorkerLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerLogs = mapped
    }

    /**
     * @param argument Log configuration options for the workers. See Module logging configuration for more information. Disabled by default.
     */
    @JvmName("eeqqruumtrmuvrvo")
    public suspend fun workerLogs(argument: suspend EnvironmentLoggingConfigurationWorkerLogsArgsBuilder.() -> Unit) {
        val toBeMapped = EnvironmentLoggingConfigurationWorkerLogsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.workerLogs = mapped
    }

    internal fun build(): EnvironmentLoggingConfigurationArgs = EnvironmentLoggingConfigurationArgs(
        dagProcessingLogs = dagProcessingLogs,
        schedulerLogs = schedulerLogs,
        taskLogs = taskLogs,
        webserverLogs = webserverLogs,
        workerLogs = workerLogs,
    )
}
