@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mwaa.kotlin.inputs

import com.pulumi.aws.mwaa.inputs.EnvironmentLoggingConfigurationTaskLogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudWatchLogGroupArn
 * @property enabled Enabling or disabling the collection of logs
 * @property logLevel Logging level. Valid values: `CRITICAL`, `ERROR`, `WARNING`, `INFO`, `DEBUG`. Will be `INFO` by default.
 */
public data class EnvironmentLoggingConfigurationTaskLogsArgs(
    public val cloudWatchLogGroupArn: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val logLevel: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.mwaa.inputs.EnvironmentLoggingConfigurationTaskLogsArgs> {
    override fun toJava(): com.pulumi.aws.mwaa.inputs.EnvironmentLoggingConfigurationTaskLogsArgs =
        com.pulumi.aws.mwaa.inputs.EnvironmentLoggingConfigurationTaskLogsArgs.builder()
            .cloudWatchLogGroupArn(cloudWatchLogGroupArn?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .logLevel(logLevel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentLoggingConfigurationTaskLogsArgs].
 */
@PulumiTagMarker
public class EnvironmentLoggingConfigurationTaskLogsArgsBuilder internal constructor() {
    private var cloudWatchLogGroupArn: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var logLevel: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("puferkrnrboficcy")
    public suspend fun cloudWatchLogGroupArn(`value`: Output<String>) {
        this.cloudWatchLogGroupArn = value
    }

    /**
     * @param value Enabling or disabling the collection of logs
     */
    @JvmName("vjntomhsmkeibvti")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Logging level. Valid values: `CRITICAL`, `ERROR`, `WARNING`, `INFO`, `DEBUG`. Will be `INFO` by default.
     */
    @JvmName("rlqeufmpdtktykud")
    public suspend fun logLevel(`value`: Output<String>) {
        this.logLevel = value
    }

    /**
     * @param value
     */
    @JvmName("mmuxsfbcbrtutfjr")
    public suspend fun cloudWatchLogGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudWatchLogGroupArn = mapped
    }

    /**
     * @param value Enabling or disabling the collection of logs
     */
    @JvmName("isadqrojsxifwhjg")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Logging level. Valid values: `CRITICAL`, `ERROR`, `WARNING`, `INFO`, `DEBUG`. Will be `INFO` by default.
     */
    @JvmName("yskyvfcoqaimbidl")
    public suspend fun logLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    internal fun build(): EnvironmentLoggingConfigurationTaskLogsArgs =
        EnvironmentLoggingConfigurationTaskLogsArgs(
            cloudWatchLogGroupArn = cloudWatchLogGroupArn,
            enabled = enabled,
            logLevel = logLevel,
        )
}
