@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mwaa.kotlin.inputs

import com.pulumi.aws.mwaa.inputs.EnvironmentNetworkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds Security groups IDs for the environment. At least one of the security group needs to allow MWAA resources to talk to each other, otherwise MWAA cannot be provisioned.
 * @property subnetIds The private subnet IDs in which the environment should be created. MWAA requires two subnets.
 */
public data class EnvironmentNetworkConfigurationArgs(
    public val securityGroupIds: Output<List<String>>,
    public val subnetIds: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.mwaa.inputs.EnvironmentNetworkConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.mwaa.inputs.EnvironmentNetworkConfigurationArgs =
        com.pulumi.aws.mwaa.inputs.EnvironmentNetworkConfigurationArgs.builder()
            .securityGroupIds(securityGroupIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [EnvironmentNetworkConfigurationArgs].
 */
@PulumiTagMarker
public class EnvironmentNetworkConfigurationArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    /**
     * @param value Security groups IDs for the environment. At least one of the security group needs to allow MWAA resources to talk to each other, otherwise MWAA cannot be provisioned.
     */
    @JvmName("pytfqdmkbwlkdjak")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("vyqyphyhfbjwexrs")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Security groups IDs for the environment. At least one of the security group needs to allow MWAA resources to talk to each other, otherwise MWAA cannot be provisioned.
     */
    @JvmName("uttykgnsodqrwdhr")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The private subnet IDs in which the environment should be created. MWAA requires two subnets.
     */
    @JvmName("mbxpelyjeigmuxav")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("vaojrnebannyodmi")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values The private subnet IDs in which the environment should be created. MWAA requires two subnets.
     */
    @JvmName("bkvpmaqxgcggqgwl")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Security groups IDs for the environment. At least one of the security group needs to allow MWAA resources to talk to each other, otherwise MWAA cannot be provisioned.
     */
    @JvmName("ymtkdslrrnmgwlcl")
    public suspend fun securityGroupIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values Security groups IDs for the environment. At least one of the security group needs to allow MWAA resources to talk to each other, otherwise MWAA cannot be provisioned.
     */
    @JvmName("cpeknlxfrnymrpdo")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The private subnet IDs in which the environment should be created. MWAA requires two subnets.
     */
    @JvmName("uvrmvgccxmkaddjv")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values The private subnet IDs in which the environment should be created. MWAA requires two subnets.
     */
    @JvmName("mpgdtwqyfharkxey")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    internal fun build(): EnvironmentNetworkConfigurationArgs = EnvironmentNetworkConfigurationArgs(
        securityGroupIds = securityGroupIds ?: throw PulumiNullFieldException("securityGroupIds"),
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
    )
}
