@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mwaa.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property dagProcessingLogs (Optional) Log configuration options for processing DAGs. See Module logging configuration for more information. Disabled by default.
 * @property schedulerLogs Log configuration options for the schedulers. See Module logging configuration for more information. Disabled by default.
 * @property taskLogs Log configuration options for DAG tasks. See Module logging configuration for more information. Enabled by default with `INFO` log level.
 * @property webserverLogs Log configuration options for the webservers. See Module logging configuration for more information. Disabled by default.
 * @property workerLogs Log configuration options for the workers. See Module logging configuration for more information. Disabled by default.
 */
public data class EnvironmentLoggingConfiguration(
    public val dagProcessingLogs: EnvironmentLoggingConfigurationDagProcessingLogs? = null,
    public val schedulerLogs: EnvironmentLoggingConfigurationSchedulerLogs? = null,
    public val taskLogs: EnvironmentLoggingConfigurationTaskLogs? = null,
    public val webserverLogs: EnvironmentLoggingConfigurationWebserverLogs? = null,
    public val workerLogs: EnvironmentLoggingConfigurationWorkerLogs? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mwaa.outputs.EnvironmentLoggingConfiguration): EnvironmentLoggingConfiguration = EnvironmentLoggingConfiguration(
            dagProcessingLogs = javaType.dagProcessingLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.mwaa.kotlin.outputs.EnvironmentLoggingConfigurationDagProcessingLogs.Companion.toKotlin(args0)
                })
            }).orElse(null),
            schedulerLogs = javaType.schedulerLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.mwaa.kotlin.outputs.EnvironmentLoggingConfigurationSchedulerLogs.Companion.toKotlin(args0)
                })
            }).orElse(null),
            taskLogs = javaType.taskLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.mwaa.kotlin.outputs.EnvironmentLoggingConfigurationTaskLogs.Companion.toKotlin(args0)
                })
            }).orElse(null),
            webserverLogs = javaType.webserverLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.mwaa.kotlin.outputs.EnvironmentLoggingConfigurationWebserverLogs.Companion.toKotlin(args0)
                })
            }).orElse(null),
            workerLogs = javaType.workerLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.mwaa.kotlin.outputs.EnvironmentLoggingConfigurationWorkerLogs.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
